var NAVTREE =
[
  [ "Developer Documentation", "index.html", [
    [ "OpenFlipper Developer Documentation", "index.html", "index" ],
    [ "OpenFlipper Branding", "a00192.html", [
      [ "CMake Options", "a00192.html#cmake_options", null ],
      [ "Application internal icons", "a00192.html#branding_icons", null ],
      [ "Mac Specific bundle branding", "a00192.html#branding_mac", null ]
    ] ],
    [ "Tracking changes of an object: The Backup Plugin", "a00246.html", [
      [ "Overview", "a00246.html#ex6_overview", null ]
    ] ],
    [ "Todo List", "a03410.html", null ],
    [ "Deprecated List", "a03412.html", null ],
    [ "Modules", "modules.html", "modules" ],
    [ "Namespaces", null, [
      [ "Namespace List", "namespaces.html", "namespaces" ],
      [ "Namespace Members", "namespacemembers.html", [
        [ "All", "namespacemembers.html", "namespacemembers_dup" ],
        [ "Functions", "namespacemembers_func.html", "namespacemembers_func" ],
        [ "Variables", "namespacemembers_vars.html", null ],
        [ "Typedefs", "namespacemembers_type.html", null ],
        [ "Enumerations", "namespacemembers_enum.html", null ],
        [ "Enumerator", "namespacemembers_eval.html", null ]
      ] ]
    ] ],
    [ "Classes", null, [
      [ "Class List", "annotated.html", "annotated" ],
      [ "Class Index", "classes.html", null ],
      [ "Class Hierarchy", "hierarchy.html", "hierarchy" ],
      [ "Class Members", "functions.html", [
        [ "All", "functions.html", "functions_dup" ],
        [ "Functions", "functions_func.html", "functions_func" ],
        [ "Variables", "functions_vars.html", "functions_vars" ],
        [ "Typedefs", "functions_type.html", "functions_type" ],
        [ "Enumerations", "functions_enum.html", null ],
        [ "Enumerator", "functions_eval.html", null ],
        [ "Properties", "functions_prop.html", null ],
        [ "Related Functions", "functions_rela.html", null ]
      ] ]
    ] ],
    [ "Files", null, [
      [ "File List", "files.html", "files" ],
      [ "File Members", "globals.html", [
        [ "All", "globals.html", null ],
        [ "Functions", "globals_func.html", null ],
        [ "Variables", "globals_vars.html", null ],
        [ "Typedefs", "globals_type.html", null ],
        [ "Enumerations", "globals_enum.html", null ],
        [ "Enumerator", "globals_eval.html", null ],
        [ "Macros", "globals_defs.html", null ]
      ] ]
    ] ]
  ] ]
];

var NAVTREEINDEX =
[
".html",
"a00148.html#loadSaveInterface_deleteObjects",
"a00258.html#a108ad05477eaa77502639b4ac3ee0d96",
"a00269.html#a88db910f48bfa7c42c873888bed4cfc6",
"a00295.html#a74ac2ce1c0294b9aa0923bfdbf800a61",
"a00303.html#a16690432d40ab507d2542bf889b3b271",
"a00304.html#a95fd6db89a0532245233c10127f2a11d",
"a00314.html#a06b09c521040707f6f68a1300668538d",
"a00324.html#a0d525d1badf6c1dd6765630f1966b303",
"a00325.html#ab4cee5f2014117f11d396fd3122f15e6",
"a00328.html#ae622ae0891629ae16cab6097b7ee9fbe",
"a00338.html#a29f61a3902841c6b006d57614a05a53f",
"a00364.html#ac4dd8b77582a7b54f8ab3bf358f22696",
"a00376.html#a345a381656364c38c49ee42a0bc94481",
"a00381.html#a0bc6fdb8e8d5ec2672bcd05cda22a01a",
"a00390.html#afb81aaa80c3dd00a71d6e9b027c3404f",
"a00409.html#a24331db5803a7d8abe1d9d571f00a37b",
"a00409.html#ae0919c8e4aec19ef540374f4ba0b41bc",
"a00428.html#a97468e58367ebdc763fc2550421602d5",
"a00440.html#af65a12b995f0483dd423001c0d5066ec",
"a00463.html",
"a00467.html#a81da22e0a1240ec7f96e8ba9c92be954",
"a00468.html#a3255d46743c948b9ad1a8547a920615a",
"a00468.html#aea2c119b6c61db50a03b88a2039c2f60",
"a00479.html#ae409204d1c7d0bdd55ba79c986c0f2dc",
"a00495.html#af2eaba55c54d9d1257729eb3d421f7d3",
"a00507.html#a342ce33b005f5662d5ff8e2200b90fc7",
"a00508.html#ae6b2b3cf4d94223ab80777e1026702ae",
"a00529.html#a053a1e28a2b2156e0eb8dd98fad13adf",
"a00550.html#a4e6b4dc445ca71eaeb8c1d4d96c6aebd",
"a00573.html#a03b01d30a7af7d61b0dc8c4c11e2c647",
"a00577.html#af589ad67d54e6e4ff0c829ef85fb6729",
"a00586.html#a690c18056f9093f5f9f46564e9ce4a74",
"a00597.html#a780d5ce09d37e07b88de978c2218eb29",
"a00627.html#a63eae508116384dbf535f32ab5c8109a",
"a00642.html#a0a81402a869307e1a9eba460cdc173d1",
"a00643.html#ab05d4e2514546ef812d38fe770714992",
"a00652.html#a3ee498f1a82cb698dad5618fcf559aec",
"a00658.html#a849681db7f37152bd269f98fa04f61f4",
"a00689.html#aef46307b0b84088a2e14a15e95fed714",
"a00706.html#a31b821f081b17360e519f7edf8567736",
"a00720.html#a9db90be91426b4d2f40d9dfd95dae693",
"a00734.html#a4c11466a35c7cc46f753e7015dbdffbc",
"a00746.html#ada76265428af53bc5c47efe9b5240ff5",
"a00752.html#afa555efd568e06ca4b493ba4055c753a",
"a00766.html#a0085a1915a2fb26d0d9c71d72d6f5bc3",
"a00777.html#ab16104eb10dc6711c910e02fd2ba16c3",
"a00790.html#a369c619b13e59788dcdbc4302b4a863b",
"a00794.html#ac67484899850c36a99f33156e8f208dd",
"a00814.html#a7540278dd8568645cb17ce7707303667",
"a00820.html#ac8a84a36a8075400ef2a893f4d98b3cf",
"a00831.html#a767f32508ce0666320f08c9769ed6d9e",
"a00837.html#a44aef64f0f8053aa7041f13ceeeac190",
"a00855.html",
"a00867.html#a9c68027d454364bb949026efa3c2df9a",
"a00889.html#a046c5f9ff5b18276ef82efacf93acd96",
"a00905.html#a82fa561f30f8794a2ae8c11661784178",
"a00912.html#ac363a536dfcefe69292ddf2393f01427",
"a00933.html#a82e416b09e7718dbbdcbc4291acee268",
"a00944.html#a311a34e11ee840ff8f73a581f971bb0a",
"a00966.html#a6009ff8916559f3e10ee037e4bf7fe5f",
"a00979.html#a3a16b2d44225b8786ccfb07104dd5c25",
"a00979.html#ad460368545a720385ed020b1eab713df",
"a00986.html#ad598b66b5db16ecc491d38e3d80f2c9ba1806b9b9bd54c30e7efab81821ccb73d",
"a00988.html#aea99fa239d2a436a737d6caeada0d99c",
"a01004.html#a3d9065ebefd56c28718076bdba791a0e",
"a01020.html#a77a3ea0fa88505258591309a4608d978",
"a01034.html#a1126c809f28e836be909a14d34f63fee",
"a01043.html#af1bd069dea5e99faf6ed51aaa9eb85b0",
"a01060.html#aba4fa06cb981125aadb25f13db4a1b3b",
"a01061.html#ac8d75dee29e3c3d0272af91ae13f18db",
"a01072.html#a94e62cd416ff8ee2709471a8e0ba1b00",
"a01081.html#a20ff4a9994534f3ce163d611e01510c1",
"a01090.html#a13eb7498a8c6e0016fb4b9c6537c0713",
"a01109.html#a24457b32200bfa386082bd2908100c6f",
"a01116.html#a2a1e48638b3d9da998b6c6a150e3050c",
"a01130.html#abb5440077fc258707249a3cd1203e097",
"a01141.html#ae107d53fc581153ea8210538a0b63e92",
"a01157.html#af788b0b8e78f2b9a492cac22d99f32d3",
"a01164.html#a3c7068c03c7a933e7148ab6124092dd1",
"a01168.html#a2e99fe86312a22a2fbd87c276c723ead",
"a01183.html#a7be9bb9b6eb11c705a885bd9d537bba0",
"a01190.html#aac20870e5ab4d710f08ce781d2fe01eb",
"a01205.html#aed9c534d5b6df5d02e8d487163ab7a1d",
"a01221.html#aa2eb57c9655d86e11788f1da36377aaf",
"a01229.html#a41737086852ccdb229e93f5dbd227414",
"a01239.html#ae517e92b60728d2917ad7a1089e9a9b9",
"a01256.html#abb2ae5b8ce66c0967f89a22ccdb5b94c",
"a01277.html#a8a52c5d38e1fc69a01a495ffae98efdf",
"a01289.html#a74df9a02305a1f10fe006b8bf7818614",
"a01300.html#ac50f80dc15e6351e56f546253f40d0f5",
"a01314.html#ab87ce93f9f960f28f1378842ca999b6c",
"a01321.html#a86e9f718554e3d862a512143966fea0fa069f8163be1891a9b1f3db2f15796e54",
"a01327.html#ac354409184d7a4fc68694024b8ff34fc",
"a01348.html#a133bc82be6dcb3c6574ba6ebb04ff8f1",
"a01363.html#a4879c0771491b178ff9c477f3273b349",
"a01384.html#aa386178893dee4bbda20a78b92eec68f",
"a01412.html#a16d804ada30ebae933bfe619e8e5096f",
"a01441.html#a448188bd4a10d2d9f1dba08198a2d5d7",
"a01451.html#a0ea89a122f54777f270c2b6e11d53453",
"a01463.html",
"a01466.html#a49ecf90766764c48e5bba121c1b096eb",
"a01472.html#afeafde7cf993d4460d25abba9ce9a953",
"a01634_source.html",
"a01858_source.html",
"a02039.html",
"a02216_source.html",
"a02311.html",
"a02444.html#a595b2880f3ae74561ba390e3fd8c0e7ca39fe22d7b704805a8e30697a4a07d8fc",
"a02495.html#a605575011e4f624aa3c64bd25a54e2f4",
"a02607_source.html",
"a02845_source.html",
"a03095_source.html",
"a03396.html",
"dir_b1d0c87f3afec998489a8b35c82f6b4e.html",
"namespacemembers_p.html"
];

var SYNCONMSG = 'click to disable panel synchronisation';
var SYNCOFFMSG = 'click to enable panel synchronisation';
var navTreeSubIndices = new Array();

function getData(varName)
{
  var i = varName.lastIndexOf('/');
  var n = i>=0 ? varName.substring(i+1) : varName;
  return eval(n.replace(/\-/g,'_'));
}

function stripPath(uri)
{
  return uri.substring(uri.lastIndexOf('/')+1);
}

function stripPath2(uri)
{
  var i = uri.lastIndexOf('/');
  var s = uri.substring(i+1);
  var m = uri.substring(0,i+1).match(/\/d\w\/d\w\w\/$/);
  return m ? uri.substring(i-6) : s;
}

function hashValue()
{
  return $(location).attr('hash').substring(1).replace(/[^\w\-]/g,'');
}

function hashUrl()
{
  return '#'+hashValue();
}

function pathName()
{
  return $(location).attr('pathname').replace(/[^-A-Za-z0-9+&@#/%?=~_|!:,.;\(\)]/g, '');
}

function localStorageSupported()
{
  try {
    return 'localStorage' in window && window['localStorage'] !== null && window.localStorage.getItem;
  }
  catch(e) {
    return false;
  }
}


function storeLink(link)
{
  if (!$("#nav-sync").hasClass('sync') && localStorageSupported()) {
      window.localStorage.setItem('navpath',link);
  }
}

function deleteLink()
{
  if (localStorageSupported()) {
    window.localStorage.setItem('navpath','');
  }
}

function cachedLink()
{
  if (localStorageSupported()) {
    return window.localStorage.getItem('navpath');
  } else {
    return '';
  }
}

function getScript(scriptName,func,show)
{
  var head = document.getElementsByTagName("head")[0]; 
  var script = document.createElement('script');
  script.id = scriptName;
  script.type = 'text/javascript';
  script.onload = func; 
  script.src = scriptName+'.js'; 
  if ($.browser.msie && $.browser.version<=8) { 
    // script.onload does not work with older versions of IE
    script.onreadystatechange = function() {
      if (script.readyState=='complete' || script.readyState=='loaded') { 
        func(); if (show) showRoot(); 
      }
    }
  }
  head.appendChild(script); 
}

function createIndent(o,domNode,node,level)
{
  var level=-1;
  var n = node;
  while (n.parentNode) { level++; n=n.parentNode; }
  if (node.childrenData) {
    var imgNode = document.createElement("img");
    imgNode.style.paddingLeft=(16*level).toString()+'px';
    imgNode.width  = 16;
    imgNode.height = 22;
    imgNode.border = 0;
    node.plus_img = imgNode;
    node.expandToggle = document.createElement("a");
    node.expandToggle.href = "javascript:void(0)";
    node.expandToggle.onclick = function() {
      if (node.expanded) {
        $(node.getChildrenUL()).slideUp("fast");
        node.plus_img.src = node.relpath+"ftv2pnode.png";
        node.expanded = false;
      } else {
        expandNode(o, node, false, false);
      }
    }
    node.expandToggle.appendChild(imgNode);
    domNode.appendChild(node.expandToggle);
    imgNode.src = node.relpath+"ftv2pnode.png";
  } else {
    var span = document.createElement("span");
    span.style.display = 'inline-block';
    span.style.width   = 16*(level+1)+'px';
    span.style.height  = '22px';
    span.innerHTML = '&#160;';
    domNode.appendChild(span);
  } 
}

var animationInProgress = false;

function gotoAnchor(anchor,aname,updateLocation)
{
  var pos, docContent = $('#doc-content');
  var ancParent = $(anchor.parent());
  if (ancParent.hasClass('memItemLeft') ||
      ancParent.hasClass('fieldname') ||
      ancParent.hasClass('fieldtype') ||
      ancParent.is(':header'))
  {
    pos = ancParent.position().top;
  } else if (anchor.position()) {
    pos = anchor.position().top;
  }
  if (pos) {
    var dist = Math.abs(Math.min(
               pos-docContent.offset().top,
               docContent[0].scrollHeight-
               docContent.height()-docContent.scrollTop()));
    animationInProgress=true;
    docContent.animate({
      scrollTop: pos + docContent.scrollTop() - docContent.offset().top
    },Math.max(50,Math.min(500,dist)),function(){
      if (updateLocation) window.location.href=aname;
      animationInProgress=false;
    });
  }
}

function newNode(o, po, text, link, childrenData, lastNode)
{
  var node = new Object();
  node.children = Array();
  node.childrenData = childrenData;
  node.depth = po.depth + 1;
  node.relpath = po.relpath;
  node.isLast = lastNode;

  node.li = document.createElement("li");
  po.getChildrenUL().appendChild(node.li);
  node.parentNode = po;

  node.itemDiv = document.createElement("div");
  node.itemDiv.className = "item";

  node.labelSpan = document.createElement("span");
  node.labelSpan.className = "label";

  createIndent(o,node.itemDiv,node,0);
  node.itemDiv.appendChild(node.labelSpan);
  node.li.appendChild(node.itemDiv);

  var a = document.createElement("a");
  node.labelSpan.appendChild(a);
  node.label = document.createTextNode(text);
  node.expanded = false;
  a.appendChild(node.label);
  if (link) {
    var url;
    if (link.substring(0,1)=='^') {
      url = link.substring(1);
      link = url;
    } else {
      url = node.relpath+link;
    }
    a.className = stripPath(link.replace('#',':'));
    if (link.indexOf('#')!=-1) {
      var aname = '#'+link.split('#')[1];
      var srcPage = stripPath(pathName());
      var targetPage = stripPath(link.split('#')[0]);
      a.href = srcPage!=targetPage ? url : "javascript:void(0)"; 
      a.onclick = function(){
        storeLink(link);
        if (!$(a).parent().parent().hasClass('selected'))
        {
          $('.item').removeClass('selected');
          $('.item').removeAttr('id');
          $(a).parent().parent().addClass('selected');
          $(a).parent().parent().attr('id','selected');
        }
        var anchor = $(aname);
        gotoAnchor(anchor,aname,true);
      };
    } else {
      a.href = url;
      a.onclick = function() { storeLink(link); }
    }
  } else {
    if (childrenData != null) 
    {
      a.className = "nolink";
      a.href = "javascript:void(0)";
      a.onclick = node.expandToggle.onclick;
    }
  }

  node.childrenUL = null;
  node.getChildrenUL = function() {
    if (!node.childrenUL) {
      node.childrenUL = document.createElement("ul");
      node.childrenUL.className = "children_ul";
      node.childrenUL.style.display = "none";
      node.li.appendChild(node.childrenUL);
    }
    return node.childrenUL;
  };

  return node;
}

function showRoot()
{
  var headerHeight = $("#top").height();
  var footerHeight = $("#nav-path").height();
  var windowHeight = $(window).height() - headerHeight - footerHeight;
  (function (){ // retry until we can scroll to the selected item
    try {
      var navtree=$('#nav-tree');
      navtree.scrollTo('#selected',0,{offset:-windowHeight/2});
    } catch (err) {
      setTimeout(arguments.callee, 0);
    }
  })();
}

function expandNode(o, node, imm, showRoot)
{
  if (node.childrenData && !node.expanded) {
    if (typeof(node.childrenData)==='string') {
      var varName    = node.childrenData;
      getScript(node.relpath+varName,function(){
        node.childrenData = getData(varName);
        expandNode(o, node, imm, showRoot);
      }, showRoot);
    } else {
      if (!node.childrenVisited) {
        getNode(o, node);
      } if (imm || ($.browser.msie && $.browser.version>8)) { 
        // somehow slideDown jumps to the start of tree for IE9 :-(
        $(node.getChildrenUL()).show();
      } else {
        $(node.getChildrenUL()).slideDown("fast");
      }
      if (node.isLast) {
        node.plus_img.src = node.relpath+"ftv2mlastnode.png";
      } else {
        node.plus_img.src = node.relpath+"ftv2mnode.png";
      }
      node.expanded = true;
    }
  }
}

function glowEffect(n,duration)
{
  n.addClass('glow').delay(duration).queue(function(next){
    $(this).removeClass('glow');next();
  });
}

function highlightAnchor()
{
  var aname = hashUrl();
  var anchor = $(aname);
  if (anchor.parent().attr('class')=='memItemLeft'){
    var rows = $('.memberdecls tr[class$="'+hashValue()+'"]');
    glowEffect(rows.children(),300); // member without details
  } else if (anchor.parent().attr('class')=='fieldname'){
    glowEffect(anchor.parent().parent(),1000); // enum value
  } else if (anchor.parent().attr('class')=='fieldtype'){
    glowEffect(anchor.parent().parent(),1000); // struct field
  } else if (anchor.parent().is(":header")) {
    glowEffect(anchor.parent(),1000); // section header
  } else {
    glowEffect(anchor.next(),1000); // normal member
  }
  gotoAnchor(anchor,aname,false);
}

function selectAndHighlight(hash,n)
{
  var a;
  if (hash) {
    var link=stripPath(pathName())+':'+hash.substring(1);
    a=$('.item a[class$="'+link+'"]');
  }
  if (a && a.length) {
    a.parent().parent().addClass('selected');
    a.parent().parent().attr('id','selected');
    highlightAnchor();
  } else if (n) {
    $(n.itemDiv).addClass('selected');
    $(n.itemDiv).attr('id','selected');
  }
  if ($('#nav-tree-contents .item:first').hasClass('selected')) {
    $('#nav-sync').css('top','30px');
  } else {
    $('#nav-sync').css('top','5px');
  }
  showRoot();
}

function showNode(o, node, index, hash)
{
  if (node && node.childrenData) {
    if (typeof(node.childrenData)==='string') {
      var varName    = node.childrenData;
      getScript(node.relpath+varName,function(){
        node.childrenData = getData(varName);
        showNode(o,node,index,hash);
      },true);
    } else {
      if (!node.childrenVisited) {
        getNode(o, node);
      }
      $(node.getChildrenUL()).css({'display':'block'});
      if (node.isLast) {
        node.plus_img.src = node.relpath+"ftv2mlastnode.png";
      } else {
        node.plus_img.src = node.relpath+"ftv2mnode.png";
      }
      node.expanded = true;
      var n = node.children[o.breadcrumbs[index]];
      if (index+1<o.breadcrumbs.length) {
        showNode(o,n,index+1,hash);
      } else {
        if (typeof(n.childrenData)==='string') {
          var varName = n.childrenData;
          getScript(n.relpath+varName,function(){
            n.childrenData = getData(varName);
            node.expanded=false;
            showNode(o,node,index,hash); // retry with child node expanded
          },true);
        } else {
          var rootBase = stripPath(o.toroot.replace(/\..+$/, ''));
          if (rootBase=="index" || rootBase=="pages" || rootBase=="search") {
            expandNode(o, n, true, true);
          }
          selectAndHighlight(hash,n);
        }
      }
    }
  } else {
    selectAndHighlight(hash);
  }
}

function removeToInsertLater(element) {
  var parentNode = element.parentNode;
  var nextSibling = element.nextSibling;
  parentNode.removeChild(element);
  return function() {
    if (nextSibling) {
      parentNode.insertBefore(element, nextSibling);
    } else {
      parentNode.appendChild(element);
    }
  };
}

function getNode(o, po)
{
  var insertFunction = removeToInsertLater(po.li);
  po.childrenVisited = true;
  var l = po.childrenData.length-1;
  for (var i in po.childrenData) {
    var nodeData = po.childrenData[i];
    po.children[i] = newNode(o, po, nodeData[0], nodeData[1], nodeData[2],
      i==l);
  }
  insertFunction();
}

function gotoNode(o,subIndex,root,hash,relpath)
{
  var nti = navTreeSubIndices[subIndex][root+hash];
  o.breadcrumbs = $.extend(true, [], nti ? nti : navTreeSubIndices[subIndex][root]);
  if (!o.breadcrumbs && root!=NAVTREE[0][1]) { // fallback: show index
    navTo(o,NAVTREE[0][1],"",relpath);
    $('.item').removeClass('selected');
    $('.item').removeAttr('id');
  }
  if (o.breadcrumbs) {
    o.breadcrumbs.unshift(0); // add 0 for root node
    showNode(o, o.node, 0, hash);
  }
}

function navTo(o,root,hash,relpath)
{
  var link = cachedLink();
  if (link) {
    var parts = link.split('#');
    root = parts[0];
    if (parts.length>1) hash = '#'+parts[1].replace(/[^\w\-]/g,'');
    else hash='';
  }
  if (hash.match(/^#l\d+$/)) {
    var anchor=$('a[name='+hash.substring(1)+']');
    glowEffect(anchor.parent(),1000); // line number
    hash=''; // strip line number anchors
  }
  var url=root+hash;
  var i=-1;
  while (NAVTREEINDEX[i+1]<=url) i++;
  if (i==-1) { i=0; root=NAVTREE[0][1]; } // fallback: show index
  if (navTreeSubIndices[i]) {
    gotoNode(o,i,root,hash,relpath)
  } else {
    getScript(relpath+'navtreeindex'+i,function(){
      navTreeSubIndices[i] = eval('NAVTREEINDEX'+i);
      if (navTreeSubIndices[i]) {
        gotoNode(o,i,root,hash,relpath);
      }
    },true);
  }
}

function showSyncOff(n,relpath)
{
    n.html('<img src="'+relpath+'sync_off.png" title="'+SYNCOFFMSG+'"/>');
}

function showSyncOn(n,relpath)
{
    n.html('<img src="'+relpath+'sync_on.png" title="'+SYNCONMSG+'"/>');
}

function toggleSyncButton(relpath)
{
  var navSync = $('#nav-sync');
  if (navSync.hasClass('sync')) {
    navSync.removeClass('sync');
    showSyncOff(navSync,relpath);
    storeLink(stripPath2(pathName())+hashUrl());
  } else {
    navSync.addClass('sync');
    showSyncOn(navSync,relpath);
    deleteLink();
  }
}

function initNavTree(toroot,relpath)
{
  var o = new Object();
  o.toroot = toroot;
  o.node = new Object();
  o.node.li = document.getElementById("nav-tree-contents");
  o.node.childrenData = NAVTREE;
  o.node.children = new Array();
  o.node.childrenUL = document.createElement("ul");
  o.node.getChildrenUL = function() { return o.node.childrenUL; };
  o.node.li.appendChild(o.node.childrenUL);
  o.node.depth = 0;
  o.node.relpath = relpath;
  o.node.expanded = false;
  o.node.isLast = true;
  o.node.plus_img = document.createElement("img");
  o.node.plus_img.src = relpath+"ftv2pnode.png";
  o.node.plus_img.width = 16;
  o.node.plus_img.height = 22;

  if (localStorageSupported()) {
    var navSync = $('#nav-sync');
    if (cachedLink()) {
      showSyncOff(navSync,relpath);
      navSync.removeClass('sync');
    } else {
      showSyncOn(navSync,relpath);
    }
    navSync.click(function(){ toggleSyncButton(relpath); });
  }

  $(window).load(function(){
    navTo(o,toroot,hashUrl(),relpath);
    showRoot();
  });

  $(window).bind('hashchange', function(){
     if (window.location.hash && window.location.hash.length>1){
       var a;
       if ($(location).attr('hash')){
         var clslink=stripPath(pathName())+':'+hashValue();
         a=$('.item a[class$="'+clslink.replace(/</g,'\\3c ')+'"]');
       }
       if (a==null || !$(a).parent().parent().hasClass('selected')){
         $('.item').removeClass('selected');
         $('.item').removeAttr('id');
       }
       var link=stripPath2(pathName());
       navTo(o,link,hashUrl(),relpath);
     } else if (!animationInProgress) {
       $('#doc-content').scrollTop(0);
       $('.item').removeClass('selected');
       $('.item').removeAttr('id');
       navTo(o,toroot,hashUrl(),relpath);
     }
  })
}

