/*===========================================================================*\
*                                                                            *
*                              OpenFlipper                                   *
 *           Copyright (c) 2001-2015, RWTH-Aachen University                 *
 *           Department of Computer Graphics and Multimedia                  *
 *                          All rights reserved.                             *
 *                            www.openflipper.org                            *
 *                                                                           *
 *---------------------------------------------------------------------------*
 * This file is part of OpenFlipper.                                         *
 *---------------------------------------------------------------------------*
 *                                                                           *
 * Redistribution and use in source and binary forms, with or without        *
 * modification, are permitted provided that the following conditions        *
 * are met:                                                                  *
 *                                                                           *
 * 1. Redistributions of source code must retain the above copyright notice, *
 *    this list of conditions and the following disclaimer.                  *
 *                                                                           *
 * 2. Redistributions in binary form must reproduce the above copyright      *
 *    notice, this list of conditions and the following disclaimer in the    *
 *    documentation and/or other materials provided with the distribution.   *
 *                                                                           *
 * 3. Neither the name of the copyright holder nor the names of its          *
 *    contributors may be used to endorse or promote products derived from   *
 *    this software without specific prior written permission.               *
 *                                                                           *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       *
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED *
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A           *
 * PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER *
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,  *
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,       *
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR        *
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF    *
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING      *
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS        *
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.              *
*                                                                            *
\*===========================================================================*/

/*===========================================================================*\
*                                                                            *
*   $Revision: 11127 $                                                       *
*   $LastChangedBy: moebius $                                                *
*   $Date: 2011-03-15 16:18:28 +0100 (Di, 15 Mär 2011) $                     *
*                                                                            *
\*===========================================================================*/

#ifndef HOLEINFO_HH
#define HOLEINFO_HH


#include <OpenFlipper/common/perObjectData.hh>
#include <OpenFlipper/common/Types.hh>

#include "HoleFillerT.hh"

template< class MeshT >
class HoleInfo : public PerObjectData
{
  
  public :
    typedef std::vector< typename MeshT::EdgeHandle > Hole;

  private :
    // the mesh
    MeshT* mesh_;
    
    // list of holes
    std::vector< Hole > holes_;

    // holeFiller
    HoleFiller< MeshT >* filler_;
 
  public :

    //Konstruktor
    HoleInfo(MeshT* _mesh);
  
    //Destruktor
    ~HoleInfo();

    // find all holes in the mesh
    void getHoles();

    //fill hole with given index
    void fillHole(int _index, int _stages = 3 );

    //fill hole with given boundary edgeHandle
    void fillHole(typename MeshT::EdgeHandle _eh, int _stages = 3 );

    //fill all holes
    void fillAllHoles( int _stages = 3 );

    //select a hole with given index
    void selectHole(int _index);

    std::vector< std::vector< typename MeshT::EdgeHandle > >* holes();
};

#if defined(INCLUDE_TEMPLATES) && !defined(HOLEINFO_C)
#define HOLEINFO_TEMPLATES
#include "HoleInfoT.cc"
#endif

#endif //HOLEINFO_HH
