include(ACGCommon)

link_directories (
  ${ADDITIONAL_PLUGINLIB_LINK_DIRS}
)

#=======================================================
# General defines
#=======================================================

# generate dllexport macros on windows
if (WIN32)
  add_definitions (
    -DPLUGINLIBDLL
    -DUSEPLUGINLIBDLL
    -DBUILDOBJECTTYPEDLL
    -DACGDLL
    -DUSEACG
  )
endif ()

#=======================================================
# Cleanup
#=======================================================

# collect all header,source files
acg_append_files_recursive (headers "*.hh" . )
acg_append_files_recursive (sources "*.cc" . )


# Match our current directory name
string (REGEX MATCH "[^/\\]*$" TYPENAME ${CMAKE_CURRENT_SOURCE_DIR})
string(TOUPPER ${TYPENAME} TYPENAME )

include_directories (
  ..
  ${ACG_INCLUDE_DIR}
  ${OPENMESH_INCLUDE_DIRS}
  ${CMAKE_SOURCE_DIR}
  ${CMAKE_CURRENT_SOURCE_DIR}/../..
  ${CMAKE_CURRENT_BINARY_DIR}
  ${OPENGL_INCLUDE_DIR}
)

# remove template cc files from source file list
acg_drop_templates (sources)
acg_add_library ( ${TYPENAME} SHARED ${sources} ${headers})
set_target_properties ( ${TYPENAME} PROPERTIES MACOSX_RPATH 0 )


if ( NOT WIN32 )
  # Allow targets depending on ACG find the autogenerated header files
  target_include_directories( ${TYPENAME} PUBLIC
                               ${CMAKE_CURRENT_BINARY_DIR}/${TYPENAME}_autogen/include )
else()
  # Allow targets depending on the current type find the autogenerated header files from uic
  target_include_directories( ${TYPENAME} PUBLIC
                              $<$<CONFIG:Debug>:${CMAKE_CURRENT_BINARY_DIR}/${TYPENAME}_autogen/include_Debug/>
                              $<$<CONFIG:Release>:${CMAKE_CURRENT_BINARY_DIR}/${TYPENAME}_autogen/include_Release/> )
endif()


add_dependencies( ${TYPENAME} OpenMeshCore OpenMeshTools ACG OpenFlipperPluginLib)


target_link_libraries (${TYPENAME}
  ${OPENMESH_LIBRARIES}
  ACG
  ${QT_LIBRARIES}
  ${OPENGL_LIBRARIES}
  OpenFlipperPluginLib
)

