/*===========================================================================*\
 *                                                                           *
 *                            OpenVolumeMesh                                 *
 *        Copyright (C) 2011 by Computer Graphics Group, RWTH Aachen         *
 *                        www.openvolumemesh.org                             *
 *                                                                           *
 *---------------------------------------------------------------------------*
 *  This file is part of OpenVolumeMesh.                                     *
 *                                                                           *
 *  OpenVolumeMesh is free software: you can redistribute it and/or modify   *
 *  it under the terms of the GNU Lesser General Public License as           *
 *  published by the Free Software Foundation, either version 3 of           *
 *  the License, or (at your option) any later version with the              *
 *  following exceptions:                                                    *
 *                                                                           *
 *  If other files instantiate templates or use macros                       *
 *  or inline functions from this file, or you compile this file and         *
 *  link it with other files to produce an executable, this file does        *
 *  not by itself cause the resulting executable to be covered by the        *
 *  GNU Lesser General Public License. This exception does not however       *
 *  invalidate any other reasons why the executable file might be            *
 *  covered by the GNU Lesser General Public License.                        *
 *                                                                           *
 *  OpenVolumeMesh is distributed in the hope that it will be useful,        *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 *  GNU Lesser General Public License for more details.                      *
 *                                                                           *
 *  You should have received a copy of the GNU LesserGeneral Public          *
 *  License along with OpenVolumeMesh.  If not,                              *
 *  see <http://www.gnu.org/licenses/>.                                      *
 *                                                                           *
\*===========================================================================*/


#pragma once

#include "OpenVolumeMeshHandle.hh"
#include "Entities.hh"

namespace OpenVolumeMesh {

template<typename EntityTag,
    typename = typename std::enable_if<is_entity<EntityTag>::value>::type>
class PropHandleT : public OpenVolumeMeshHandle
{
public:
    using Entity = EntityTag;
    using OpenVolumeMeshHandle::OpenVolumeMeshHandle;
};

using VertexPropHandle   = PropHandleT<Entity::Vertex>;
using EdgePropHandle     = PropHandleT<Entity::Edge>;
using HalfEdgePropHandle = PropHandleT<Entity::HalfEdge>;
using FacePropHandle     = PropHandleT<Entity::Face>;
using HalfFacePropHandle = PropHandleT<Entity::HalfFace>;
using CellPropHandle     = PropHandleT<Entity::Cell>;
using MeshPropHandle     = PropHandleT<Entity::Mesh>;

} // Namespace OpenVolumeMesh

