/*===========================================================================*\
 *                                                                           *
 *                              OpenFlipper                                  *
 *           Copyright (c) 2001-2015, RWTH-Aachen University                 *
 *           Department of Computer Graphics and Multimedia                  *
 *                          All rights reserved.                             *
 *                            www.openflipper.org                            *
 *                                                                           *
 *---------------------------------------------------------------------------*
 * This file is part of OpenFlipper.                                         *
 *---------------------------------------------------------------------------*
 *                                                                           *
 * Redistribution and use in source and binary forms, with or without        *
 * modification, are permitted provided that the following conditions        *
 * are met:                                                                  *
 *                                                                           *
 * 1. Redistributions of source code must retain the above copyright notice, *
 *    this list of conditions and the following disclaimer.                  *
 *                                                                           *
 * 2. Redistributions in binary form must reproduce the above copyright      *
 *    notice, this list of conditions and the following disclaimer in the    *
 *    documentation and/or other materials provided with the distribution.   *
 *                                                                           *
 * 3. Neither the name of the copyright holder nor the names of its          *
 *    contributors may be used to endorse or promote products derived from   *
 *    this software without specific prior written permission.               *
 *                                                                           *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       *
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED *
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A           *
 * PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER *
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,  *
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,       *
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR        *
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF    *
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING      *
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS        *
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.              *
 *                                                                           *
\*===========================================================================*/




//=============================================================================
//
//  Stipple Polygon Transparency - IMPLEMENTATION
//
//=============================================================================

//== INCLUDES =================================================================


#include "stipple_alpha.hh"
#include "gl.hh"
#include <GL/GLState.hh>


//== NAMESPACES ===============================================================
namespace ACG {
//== IMPLEMENTATION ========================================================== 


const GLubyte stippleMask[17][128] =
{
  /* NOTE: 0% opaqueness is faster to set and probably faster to render with:
	ACG::GLState::disable(GL_POLYGON_STIPPLE);
	glColorMask(GL_FALSE, GL_FALSE, GL_FALSE, GL_FALSE); */
  {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},

  {0x88, 0x88, 0x88, 0x88, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x88, 0x88, 0x88, 0x88, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x88, 0x88, 0x88, 0x88, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x88, 0x88, 0x88, 0x88, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x88, 0x88, 0x88, 0x88, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x88, 0x88, 0x88, 0x88, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x88, 0x88, 0x88, 0x88, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x88, 0x88, 0x88, 0x88, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},

  {0x88, 0x88, 0x88, 0x88, 0x00, 0x00, 0x00, 0x00, 
   0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00,
   0x88, 0x88, 0x88, 0x88, 0x00, 0x00, 0x00, 0x00, 
   0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00,
   0x88, 0x88, 0x88, 0x88, 0x00, 0x00, 0x00, 0x00, 
   0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00,
   0x88, 0x88, 0x88, 0x88, 0x00, 0x00, 0x00, 0x00, 
   0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00,
   0x88, 0x88, 0x88, 0x88, 0x00, 0x00, 0x00, 0x00, 
   0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00,
   0x88, 0x88, 0x88, 0x88, 0x00, 0x00, 0x00, 0x00, 
   0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00,
   0x88, 0x88, 0x88, 0x88, 0x00, 0x00, 0x00, 0x00, 
   0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00,
   0x88, 0x88, 0x88, 0x88, 0x00, 0x00, 0x00, 0x00, 
   0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00},

  {0xaa, 0xaa, 0xaa, 0xaa, 0x00, 0x00, 0x00, 0x00, 
   0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00,
   0xaa, 0xaa, 0xaa, 0xaa, 0x00, 0x00, 0x00, 0x00, 
   0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00,
   0xaa, 0xaa, 0xaa, 0xaa, 0x00, 0x00, 0x00, 0x00, 
   0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00,
   0xaa, 0xaa, 0xaa, 0xaa, 0x00, 0x00, 0x00, 0x00, 
   0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00,
   0xaa, 0xaa, 0xaa, 0xaa, 0x00, 0x00, 0x00, 0x00, 
   0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00,
   0xaa, 0xaa, 0xaa, 0xaa, 0x00, 0x00, 0x00, 0x00, 
   0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00,
   0xaa, 0xaa, 0xaa, 0xaa, 0x00, 0x00, 0x00, 0x00, 
   0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00,
   0xaa, 0xaa, 0xaa, 0xaa, 0x00, 0x00, 0x00, 0x00, 
   0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00},

  {0xaa, 0xaa, 0xaa, 0xaa, 0x00, 0x00, 0x00, 0x00, 
   0xaa, 0xaa, 0xaa, 0xaa, 0x00, 0x00, 0x00, 0x00,
   0xaa, 0xaa, 0xaa, 0xaa, 0x00, 0x00, 0x00, 0x00, 
   0xaa, 0xaa, 0xaa, 0xaa, 0x00, 0x00, 0x00, 0x00,
   0xaa, 0xaa, 0xaa, 0xaa, 0x00, 0x00, 0x00, 0x00, 
   0xaa, 0xaa, 0xaa, 0xaa, 0x00, 0x00, 0x00, 0x00,
   0xaa, 0xaa, 0xaa, 0xaa, 0x00, 0x00, 0x00, 0x00, 
   0xaa, 0xaa, 0xaa, 0xaa, 0x00, 0x00, 0x00, 0x00,
   0xaa, 0xaa, 0xaa, 0xaa, 0x00, 0x00, 0x00, 0x00, 
   0xaa, 0xaa, 0xaa, 0xaa, 0x00, 0x00, 0x00, 0x00,
   0xaa, 0xaa, 0xaa, 0xaa, 0x00, 0x00, 0x00, 0x00, 
   0xaa, 0xaa, 0xaa, 0xaa, 0x00, 0x00, 0x00, 0x00,
   0xaa, 0xaa, 0xaa, 0xaa, 0x00, 0x00, 0x00, 0x00, 
   0xaa, 0xaa, 0xaa, 0xaa, 0x00, 0x00, 0x00, 0x00,
   0xaa, 0xaa, 0xaa, 0xaa, 0x00, 0x00, 0x00, 0x00, 
   0xaa, 0xaa, 0xaa, 0xaa, 0x00, 0x00, 0x00, 0x00},

  {0xaa, 0xaa, 0xaa, 0xaa, 0x44, 0x44, 0x44, 0x44, 
   0xaa, 0xaa, 0xaa, 0xaa, 0x00, 0x00, 0x00, 0x00,
   0xaa, 0xaa, 0xaa, 0xaa, 0x44, 0x44, 0x44, 0x44, 
   0xaa, 0xaa, 0xaa, 0xaa, 0x00, 0x00, 0x00, 0x00,
   0xaa, 0xaa, 0xaa, 0xaa, 0x44, 0x44, 0x44, 0x44, 
   0xaa, 0xaa, 0xaa, 0xaa, 0x00, 0x00, 0x00, 0x00,
   0xaa, 0xaa, 0xaa, 0xaa, 0x44, 0x44, 0x44, 0x44, 
   0xaa, 0xaa, 0xaa, 0xaa, 0x00, 0x00, 0x00, 0x00,
   0xaa, 0xaa, 0xaa, 0xaa, 0x44, 0x44, 0x44, 0x44, 
   0xaa, 0xaa, 0xaa, 0xaa, 0x00, 0x00, 0x00, 0x00,
   0xaa, 0xaa, 0xaa, 0xaa, 0x44, 0x44, 0x44, 0x44, 
   0xaa, 0xaa, 0xaa, 0xaa, 0x00, 0x00, 0x00, 0x00,
   0xaa, 0xaa, 0xaa, 0xaa, 0x44, 0x44, 0x44, 0x44, 
   0xaa, 0xaa, 0xaa, 0xaa, 0x00, 0x00, 0x00, 0x00,
   0xaa, 0xaa, 0xaa, 0xaa, 0x44, 0x44, 0x44, 0x44, 
   0xaa, 0xaa, 0xaa, 0xaa, 0x00, 0x00, 0x00, 0x00},

  {0xaa, 0xaa, 0xaa, 0xaa, 0x44, 0x44, 0x44, 0x44, 
   0xaa, 0xaa, 0xaa, 0xaa, 0x11, 0x11, 0x11, 0x11,
   0xaa, 0xaa, 0xaa, 0xaa, 0x44, 0x44, 0x44, 0x44, 
   0xaa, 0xaa, 0xaa, 0xaa, 0x11, 0x11, 0x11, 0x11,
   0xaa, 0xaa, 0xaa, 0xaa, 0x44, 0x44, 0x44, 0x44, 
   0xaa, 0xaa, 0xaa, 0xaa, 0x11, 0x11, 0x11, 0x11,
   0xaa, 0xaa, 0xaa, 0xaa, 0x44, 0x44, 0x44, 0x44, 
   0xaa, 0xaa, 0xaa, 0xaa, 0x11, 0x11, 0x11, 0x11,
   0xaa, 0xaa, 0xaa, 0xaa, 0x44, 0x44, 0x44, 0x44, 
   0xaa, 0xaa, 0xaa, 0xaa, 0x11, 0x11, 0x11, 0x11,
   0xaa, 0xaa, 0xaa, 0xaa, 0x44, 0x44, 0x44, 0x44, 
   0xaa, 0xaa, 0xaa, 0xaa, 0x11, 0x11, 0x11, 0x11,
   0xaa, 0xaa, 0xaa, 0xaa, 0x44, 0x44, 0x44, 0x44, 
   0xaa, 0xaa, 0xaa, 0xaa, 0x11, 0x11, 0x11, 0x11,
   0xaa, 0xaa, 0xaa, 0xaa, 0x44, 0x44, 0x44, 0x44, 
   0xaa, 0xaa, 0xaa, 0xaa, 0x11, 0x11, 0x11, 0x11},

  {0xaa, 0xaa, 0xaa, 0xaa, 0x55, 0x55, 0x55, 0x55, 
   0xaa, 0xaa, 0xaa, 0xaa, 0x11, 0x11, 0x11, 0x11,
   0xaa, 0xaa, 0xaa, 0xaa, 0x55, 0x55, 0x55, 0x55, 
   0xaa, 0xaa, 0xaa, 0xaa, 0x11, 0x11, 0x11, 0x11,
   0xaa, 0xaa, 0xaa, 0xaa, 0x55, 0x55, 0x55, 0x55, 
   0xaa, 0xaa, 0xaa, 0xaa, 0x11, 0x11, 0x11, 0x11,
   0xaa, 0xaa, 0xaa, 0xaa, 0x55, 0x55, 0x55, 0x55, 
   0xaa, 0xaa, 0xaa, 0xaa, 0x11, 0x11, 0x11, 0x11,
   0xaa, 0xaa, 0xaa, 0xaa, 0x55, 0x55, 0x55, 0x55, 
   0xaa, 0xaa, 0xaa, 0xaa, 0x11, 0x11, 0x11, 0x11,
   0xaa, 0xaa, 0xaa, 0xaa, 0x55, 0x55, 0x55, 0x55, 
   0xaa, 0xaa, 0xaa, 0xaa, 0x11, 0x11, 0x11, 0x11,
   0xaa, 0xaa, 0xaa, 0xaa, 0x55, 0x55, 0x55, 0x55, 
   0xaa, 0xaa, 0xaa, 0xaa, 0x11, 0x11, 0x11, 0x11,
   0xaa, 0xaa, 0xaa, 0xaa, 0x55, 0x55, 0x55, 0x55, 
   0xaa, 0xaa, 0xaa, 0xaa, 0x11, 0x11, 0x11, 0x11},

  {0xaa, 0xaa, 0xaa, 0xaa, 0x55, 0x55, 0x55, 0x55, 
   0xaa, 0xaa, 0xaa, 0xaa, 0x55, 0x55, 0x55, 0x55,
   0xaa, 0xaa, 0xaa, 0xaa, 0x55, 0x55, 0x55, 0x55,
   0xaa, 0xaa, 0xaa, 0xaa, 0x55, 0x55, 0x55, 0x55,
   0xaa, 0xaa, 0xaa, 0xaa, 0x55, 0x55, 0x55, 0x55, 
   0xaa, 0xaa, 0xaa, 0xaa, 0x55, 0x55, 0x55, 0x55,
   0xaa, 0xaa, 0xaa, 0xaa, 0x55, 0x55, 0x55, 0x55, 
   0xaa, 0xaa, 0xaa, 0xaa, 0x55, 0x55, 0x55, 0x55,
   0xaa, 0xaa, 0xaa, 0xaa, 0x55, 0x55, 0x55, 0x55,
   0xaa, 0xaa, 0xaa, 0xaa, 0x55, 0x55, 0x55, 0x55,
   0xaa, 0xaa, 0xaa, 0xaa, 0x55, 0x55, 0x55, 0x55, 
   0xaa, 0xaa, 0xaa, 0xaa, 0x55, 0x55, 0x55, 0x55,
   0xaa, 0xaa, 0xaa, 0xaa, 0x55, 0x55, 0x55, 0x55, 
   0xaa, 0xaa, 0xaa, 0xaa, 0x55, 0x55, 0x55, 0x55,
   0xaa, 0xaa, 0xaa, 0xaa, 0x55, 0x55, 0x55, 0x55, 
   0xaa, 0xaa, 0xaa, 0xaa, 0x55, 0x55, 0x55, 0x55},

  {0xee, 0xee, 0xee, 0xee, 0x55, 0x55, 0x55, 0x55, 
   0xaa, 0xaa, 0xaa, 0xaa, 0x55, 0x55, 0x55, 0x55,
   0xee, 0xee, 0xee, 0xee, 0x55, 0x55, 0x55, 0x55, 
   0xaa, 0xaa, 0xaa, 0xaa, 0x55, 0x55, 0x55, 0x55,
   0xee, 0xee, 0xee, 0xee, 0x55, 0x55, 0x55, 0x55, 
   0xaa, 0xaa, 0xaa, 0xaa, 0x55, 0x55, 0x55, 0x55,
   0xee, 0xee, 0xee, 0xee, 0x55, 0x55, 0x55, 0x55, 
   0xaa, 0xaa, 0xaa, 0xaa, 0x55, 0x55, 0x55, 0x55,
   0xee, 0xee, 0xee, 0xee, 0x55, 0x55, 0x55, 0x55, 
   0xaa, 0xaa, 0xaa, 0xaa, 0x55, 0x55, 0x55, 0x55,
   0xee, 0xee, 0xee, 0xee, 0x55, 0x55, 0x55, 0x55, 
   0xaa, 0xaa, 0xaa, 0xaa, 0x55, 0x55, 0x55, 0x55,
   0xee, 0xee, 0xee, 0xee, 0x55, 0x55, 0x55, 0x55, 
   0xaa, 0xaa, 0xaa, 0xaa, 0x55, 0x55, 0x55, 0x55,
   0xee, 0xee, 0xee, 0xee, 0x55, 0x55, 0x55, 0x55, 
   0xaa, 0xaa, 0xaa, 0xaa, 0x55, 0x55, 0x55, 0x55},

  {0xee, 0xee, 0xee, 0xee, 0x55, 0x55, 0x55, 0x55, 
   0xbb, 0xbb, 0xbb, 0xbb, 0x55, 0x55, 0x55, 0x55,
   0xee, 0xee, 0xee, 0xee, 0x55, 0x55, 0x55, 0x55, 
   0xbb, 0xbb, 0xbb, 0xbb, 0x55, 0x55, 0x55, 0x55,
   0xee, 0xee, 0xee, 0xee, 0x55, 0x55, 0x55, 0x55, 
   0xbb, 0xbb, 0xbb, 0xbb, 0x55, 0x55, 0x55, 0x55,
   0xee, 0xee, 0xee, 0xee, 0x55, 0x55, 0x55, 0x55, 
   0xbb, 0xbb, 0xbb, 0xbb, 0x55, 0x55, 0x55, 0x55,
   0xee, 0xee, 0xee, 0xee, 0x55, 0x55, 0x55, 0x55, 
   0xbb, 0xbb, 0xbb, 0xbb, 0x55, 0x55, 0x55, 0x55,
   0xee, 0xee, 0xee, 0xee, 0x55, 0x55, 0x55, 0x55, 
   0xbb, 0xbb, 0xbb, 0xbb, 0x55, 0x55, 0x55, 0x55,
   0xee, 0xee, 0xee, 0xee, 0x55, 0x55, 0x55, 0x55, 
   0xbb, 0xbb, 0xbb, 0xbb, 0x55, 0x55, 0x55, 0x55,
   0xee, 0xee, 0xee, 0xee, 0x55, 0x55, 0x55, 0x55, 
   0xbb, 0xbb, 0xbb, 0xbb, 0x55, 0x55, 0x55, 0x55},

  {0xff, 0xff, 0xff, 0xff, 0x55, 0x55, 0x55, 0x55, 
   0xbb, 0xbb, 0xbb, 0xbb, 0x55, 0x55, 0x55, 0x55,
   0xff, 0xff, 0xff, 0xff, 0x55, 0x55, 0x55, 0x55, 
   0xbb, 0xbb, 0xbb, 0xbb, 0x55, 0x55, 0x55, 0x55,
   0xff, 0xff, 0xff, 0xff, 0x55, 0x55, 0x55, 0x55, 
   0xbb, 0xbb, 0xbb, 0xbb, 0x55, 0x55, 0x55, 0x55,
   0xff, 0xff, 0xff, 0xff, 0x55, 0x55, 0x55, 0x55, 
   0xbb, 0xbb, 0xbb, 0xbb, 0x55, 0x55, 0x55, 0x55,
   0xff, 0xff, 0xff, 0xff, 0x55, 0x55, 0x55, 0x55, 
   0xbb, 0xbb, 0xbb, 0xbb, 0x55, 0x55, 0x55, 0x55,
   0xff, 0xff, 0xff, 0xff, 0x55, 0x55, 0x55, 0x55, 
   0xbb, 0xbb, 0xbb, 0xbb, 0x55, 0x55, 0x55, 0x55,
   0xff, 0xff, 0xff, 0xff, 0x55, 0x55, 0x55, 0x55,
   0xbb, 0xbb, 0xbb, 0xbb, 0x55, 0x55, 0x55, 0x55,
   0xff, 0xff, 0xff, 0xff, 0x55, 0x55, 0x55, 0x55, 
   0xbb, 0xbb, 0xbb, 0xbb, 0x55, 0x55, 0x55, 0x55},

  {0xff, 0xff, 0xff, 0xff, 0x55, 0x55, 0x55, 0x55, 
   0xff, 0xff, 0xff, 0xff, 0x55, 0x55, 0x55, 0x55,
   0xff, 0xff, 0xff, 0xff, 0x55, 0x55, 0x55, 0x55, 
   0xff, 0xff, 0xff, 0xff, 0x55, 0x55, 0x55, 0x55,
   0xff, 0xff, 0xff, 0xff, 0x55, 0x55, 0x55, 0x55, 
   0xff, 0xff, 0xff, 0xff, 0x55, 0x55, 0x55, 0x55,
   0xff, 0xff, 0xff, 0xff, 0x55, 0x55, 0x55, 0x55, 
   0xff, 0xff, 0xff, 0xff, 0x55, 0x55, 0x55, 0x55,
   0xff, 0xff, 0xff, 0xff, 0x55, 0x55, 0x55, 0x55, 
   0xff, 0xff, 0xff, 0xff, 0x55, 0x55, 0x55, 0x55,
   0xff, 0xff, 0xff, 0xff, 0x55, 0x55, 0x55, 0x55, 
   0xff, 0xff, 0xff, 0xff, 0x55, 0x55, 0x55, 0x55,
   0xff, 0xff, 0xff, 0xff, 0x55, 0x55, 0x55, 0x55, 
   0xff, 0xff, 0xff, 0xff, 0x55, 0x55, 0x55, 0x55,
   0xff, 0xff, 0xff, 0xff, 0x55, 0x55, 0x55, 0x55, 
   0xff, 0xff, 0xff, 0xff, 0x55, 0x55, 0x55, 0x55},

  {0xff, 0xff, 0xff, 0xff, 0xdd, 0xdd, 0xdd, 0xdd, 
   0xff, 0xff, 0xff, 0xff, 0x55, 0x55, 0x55, 0x55,
   0xff, 0xff, 0xff, 0xff, 0xdd, 0xdd, 0xdd, 0xdd, 
   0xff, 0xff, 0xff, 0xff, 0x55, 0x55, 0x55, 0x55,
   0xff, 0xff, 0xff, 0xff, 0xdd, 0xdd, 0xdd, 0xdd, 
   0xff, 0xff, 0xff, 0xff, 0x55, 0x55, 0x55, 0x55,
   0xff, 0xff, 0xff, 0xff, 0xdd, 0xdd, 0xdd, 0xdd, 
   0xff, 0xff, 0xff, 0xff, 0x55, 0x55, 0x55, 0x55,
   0xff, 0xff, 0xff, 0xff, 0xdd, 0xdd, 0xdd, 0xdd, 
   0xff, 0xff, 0xff, 0xff, 0x55, 0x55, 0x55, 0x55,
   0xff, 0xff, 0xff, 0xff, 0xdd, 0xdd, 0xdd, 0xdd, 
   0xff, 0xff, 0xff, 0xff, 0x55, 0x55, 0x55, 0x55,
   0xff, 0xff, 0xff, 0xff, 0xdd, 0xdd, 0xdd, 0xdd, 
   0xff, 0xff, 0xff, 0xff, 0x55, 0x55, 0x55, 0x55,
   0xff, 0xff, 0xff, 0xff, 0xdd, 0xdd, 0xdd, 0xdd, 
   0xff, 0xff, 0xff, 0xff, 0x55, 0x55, 0x55, 0x55},

  {0xff, 0xff, 0xff, 0xff, 0xdd, 0xdd, 0xdd, 0xdd, 
   0xff, 0xff, 0xff, 0xff, 0x77, 0x77, 0x77, 0x77,
   0xff, 0xff, 0xff, 0xff, 0xdd, 0xdd, 0xdd, 0xdd, 
   0xff, 0xff, 0xff, 0xff, 0x77, 0x77, 0x77, 0x77,
   0xff, 0xff, 0xff, 0xff, 0xdd, 0xdd, 0xdd, 0xdd, 
   0xff, 0xff, 0xff, 0xff, 0x77, 0x77, 0x77, 0x77,
   0xff, 0xff, 0xff, 0xff, 0xdd, 0xdd, 0xdd, 0xdd, 
   0xff, 0xff, 0xff, 0xff, 0x77, 0x77, 0x77, 0x77,
   0xff, 0xff, 0xff, 0xff, 0xdd, 0xdd, 0xdd, 0xdd, 
   0xff, 0xff, 0xff, 0xff, 0x77, 0x77, 0x77, 0x77,
   0xff, 0xff, 0xff, 0xff, 0xdd, 0xdd, 0xdd, 0xdd, 
   0xff, 0xff, 0xff, 0xff, 0x77, 0x77, 0x77, 0x77,
   0xff, 0xff, 0xff, 0xff, 0xdd, 0xdd, 0xdd, 0xdd, 
   0xff, 0xff, 0xff, 0xff, 0x77, 0x77, 0x77, 0x77,
   0xff, 0xff, 0xff, 0xff, 0xdd, 0xdd, 0xdd, 0xdd, 
   0xff, 0xff, 0xff, 0xff, 0x77, 0x77, 0x77, 0x77},

  {0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
   0xff, 0xff, 0xff, 0xff, 0x77, 0x77, 0x77, 0x77,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
   0xff, 0xff, 0xff, 0xff, 0x77, 0x77, 0x77, 0x77,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
   0xff, 0xff, 0xff, 0xff, 0x77, 0x77, 0x77, 0x77,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
   0xff, 0xff, 0xff, 0xff, 0x77, 0x77, 0x77, 0x77,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
   0xff, 0xff, 0xff, 0xff, 0x77, 0x77, 0x77, 0x77,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
   0xff, 0xff, 0xff, 0xff, 0x77, 0x77, 0x77, 0x77,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
   0xff, 0xff, 0xff, 0xff, 0x77, 0x77, 0x77, 0x77,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
   0xff, 0xff, 0xff, 0xff, 0x77, 0x77, 0x77, 0x77},

  /* NOTE: 100% opaqueness is faster to set and probably faster to render with:
        ACG::GLState::disable(GL_POLYGON_STIPPLE); */
  {0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff},
};


//-----------------------------------------------------------------------------


void stipple_alpha(float _alpha)
{
  // transparent
  if (_alpha < 1.0)
  {
    if (_alpha < 0.0) _alpha = 0.0;

    ACG::GLState::enable(GL_POLYGON_STIPPLE);
    glPolygonStipple(stippleMask[ (unsigned int)(_alpha * 16.0 + 0.5)]);
  }

  // opaque
  else
  {
    ACG::GLState::disable(GL_POLYGON_STIPPLE);
  }
}


//=============================================================================
} // namespace ACG
//=============================================================================
