/*===========================================================================*\
*                                                                            *
*                              OpenFlipper                                   *
 *           Copyright (c) 2001-2015, RWTH-Aachen University                 *
 *           Department of Computer Graphics and Multimedia                  *
 *                          All rights reserved.                             *
 *                            www.openflipper.org                            *
 *                                                                           *
 *---------------------------------------------------------------------------*
 * This file is part of OpenFlipper.                                         *
 *---------------------------------------------------------------------------*
 *                                                                           *
 * Redistribution and use in source and binary forms, with or without        *
 * modification, are permitted provided that the following conditions        *
 * are met:                                                                  *
 *                                                                           *
 * 1. Redistributions of source code must retain the above copyright notice, *
 *    this list of conditions and the following disclaimer.                  *
 *                                                                           *
 * 2. Redistributions in binary form must reproduce the above copyright      *
 *    notice, this list of conditions and the following disclaimer in the    *
 *    documentation and/or other materials provided with the distribution.   *
 *                                                                           *
 * 3. Neither the name of the copyright holder nor the names of its          *
 *    contributors may be used to endorse or promote products derived from   *
 *    this software without specific prior written permission.               *
 *                                                                           *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       *
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED *
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A           *
 * PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER *
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,  *
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,       *
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR        *
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF    *
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING      *
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS        *
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.              *
*                                                                            *
\*===========================================================================*/



#ifdef ENABLE_SKELETON_SUPPORT

#ifndef OM_PROPERTY_VISUALIZER_SKIN_WEIGHTS_HH
#define OM_PROPERTY_VISUALIZER_SKIN_WEIGHTS_HH

#include "OMPropertyVisualizer.hh"

#include "Widgets/SkinWeightsWidget.hh"

#include <ObjectTypes/Skeleton/BaseSkin.hh>

#include <iostream>

template <typename MeshT>
class OMPropertyVisualizerSkinWeights: public OMPropertyVisualizer<MeshT>{

public:
    OMPropertyVisualizerSkinWeights(MeshT* _mesh, int _objectID, const PropertyInfo& _propertyInfo);
    virtual ~OMPropertyVisualizerSkinWeights(){}

protected:

    void visualizeFaceProp(bool _setDrawMode = true) override;
    void visualizeEdgeProp(bool _setDrawMode = true) override;
    void visualizeHalfedgeProp(bool _setDrawMode = true) override;
    void visualizeVertexProp(bool _setDrawMode = true) override;

    QString getPropertyText(unsigned int index) override;

    void setFacePropertyFromText(unsigned int index, QString text) override;
    void setEdgePropertyFromText(unsigned int index, QString text) override;
    void setHalfedgePropertyFromText(unsigned int index, QString text) override;
    void setVertexPropertyFromText(unsigned int index, QString text) override;

    void removeProperty() override;
    void duplicateProperty() override;

};

#if defined(INCLUDE_TEMPLATES) && !defined(OM_PROPERTY_VISUALIZER_SKIN_WEIGHTS_CC)
#include "OMPropertyVisualizerSkinWeightsT_impl.hh"
#endif

#endif /* OM_PROPERTY_VISUALIZER_SKIN_WEIGHTS_HH */

#endif /* ENABLE_SKELETON_SUPPORT */
