/* ========================================================================= *
 *                                                                           *
 *                               OpenMesh                                    *
 *           Copyright (c) 2001-2015, RWTH-Aachen University                 *
 *           Department of Computer Graphics and Multimedia                  *
 *                          All rights reserved.                             *
 *                            www.openmesh.org                               *
 *                                                                           *
 *---------------------------------------------------------------------------*
 * This file is part of OpenMesh.                                            *
 *---------------------------------------------------------------------------*
 *                                                                           *
 * Redistribution and use in source and binary forms, with or without        *
 * modification, are permitted provided that the following conditions        *
 * are met:                                                                  *
 *                                                                           *
 * 1. Redistributions of source code must retain the above copyright notice, *
 *    this list of conditions and the following disclaimer.                  *
 *                                                                           *
 * 2. Redistributions in binary form must reproduce the above copyright      *
 *    notice, this list of conditions and the following disclaimer in the    *
 *    documentation and/or other materials provided with the distribution.   *
 *                                                                           *
 * 3. Neither the name of the copyright holder nor the names of its          *
 *    contributors may be used to endorse or promote products derived from   *
 *    this software without specific prior written permission.               *
 *                                                                           *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       *
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED *
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A           *
 * PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER *
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,  *
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,       *
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR        *
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF    *
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING      *
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS        *
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.              *
 *                                                                           *
 * ========================================================================= */

/*===========================================================================*\
 *                                                                           *
 *   $Revision: 693 $                                                         *
 *   $Date: 2012-09-23 16:25:16 +0200 (So, 23 Sep 2012) $                   *
 *                                                                           *
\*===========================================================================*/


//=============================================================================
//
//  Helper Functions for generating a random number between 0.0 and 1.0 with
//  a garantueed resolution
//
//=============================================================================


#ifndef OPENMESH_UTILS_RANDOMNUMBERGENERATOR_HH
#define OPENMESH_UTILS_RANDOMNUMBERGENERATOR_HH


//== INCLUDES =================================================================


#include <OpenMesh/Core/System/config.h>
#include <cstdlib>



//== NAMESPACES ===============================================================


namespace OpenMesh {


//=============================================================================


/**  Generate a random number between 0.0 and 1.0 with a guaranteed resolution
 *   ( Number of possible values )
 *
 * Especially useful on windows, as there MAX_RAND is often only 32k which is
 * not enough resolution for a lot of applications
 */
class OPENMESHDLLEXPORT RandomNumberGenerator
{
public:

  /** \brief Constructor
  *
  * @param _resolution specifies the desired resolution for the random number generated
  */
  RandomNumberGenerator(const size_t _resolution);

  /// returns a random double between 0.0 and 1.0 with a guaranteed resolution
  double getRand() const;

  double resolution() const;

private:

  /// desired resolution
  const size_t resolution_;

  /// number of "blocks" of RAND_MAX that make up the desired _resolution
  size_t iterations_;

  /// maximum random number generated, which is used for normalization
  double maxNum_;
};

//=============================================================================
} // namespace OpenMesh
//=============================================================================
#endif // OPENMESH_UTILS_RANDOMNUMBERGENERATOR_HH defined
//=============================================================================

