//=============================================================================
//                                                                            
//                               OpenMesh                                     
//      Copyright (C) 2001-2005 by Computer Graphics Group, RWTH Aachen       
//                           www.openmesh.org                                 
//                                                                            
//-----------------------------------------------------------------------------
//                                                                            
//                                License                                     
//                                                                            
//   This library is free software; you can redistribute it and/or modify it 
//   under the terms of the GNU Library General Public License as published  
//   by the Free Software Foundation, version 2.                             
//                                                                             
//   This library is distributed in the hope that it will be useful, but       
//   WITHOUT ANY WARRANTY; without even the implied warranty of                
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         
//   Library General Public License for more details.                          
//                                                                            
//   You should have received a copy of the GNU Library General Public         
//   License along with this library; if not, write to the Free Software       
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 
//                                                                            
//-----------------------------------------------------------------------------
//                                                                            
//   $Revision: 1.3 $
//   $Date: 2005-12-21 14:02:16 $
//                                                                            
//=============================================================================


#include <iostream>
#include <OpenMesh/Core/IO/MeshIO.hh> // include before kernel type!
#include <OpenMesh/Core/Mesh/Types/TriMesh_ArrayKernelT.hh>
#include <OpenMesh/Tools/Utils/Timer.hh>
#include <OpenMesh/Tools/Smoother/JacobiLaplaceSmootherT.hh>
#include <OpenMesh/Tools/Utils/getopt.h>


//-----------------------------------------------------------------------------


using namespace OpenMesh;
using namespace Smoother;


//-----------------------------------------------------------------------------


struct MyTraits : public DefaultTraits
{
  typedef Vec3f Point;
  typedef Vec3f Normal;
};

typedef TriMesh_ArrayKernelT<MyTraits>  MyMesh;
typedef JacobiLaplaceSmootherT<MyMesh>  MySmoother;


//-----------------------------------------------------------------------------


int main(int argc, char **argv)
{
  MyMesh                   mesh;
  OpenMesh::Utils::Timer   t;
  std::string              ifname;
  std::string              ofname;
  int                      iterations;


  if (argc-optind < 3)
  {
    std::cout << std::endl;
    std::cout << "Usage: smooth <iterations> <input mesh> <output mesh>\n";
    std::cout << std::endl;
    exit(1);
  }


  // # iterations
  iterations = atoi(argv[1]);


  // read mesh
  omout() << "read mesh..." << std::flush;
  OpenMesh::IO::read_mesh(mesh, argv[2]);
  omout() << "done\n";



  // smooth
  omout() << "smoothing..." << std::flush;
  t.start(); 
  MySmoother smoother(mesh);
  smoother.initialize(MySmoother::Tangential_and_Normal, MySmoother::C0);
  smoother.smooth(iterations); 
  t.stop();
  omout() << "done (";
  omout() << t.seconds() << "s)\n";



  // write mesh
  omout() << "write mesh..." << std::flush;
  OpenMesh::IO::write_mesh(mesh, argv[3]);
  omout() << "done\n";


  return 0;
}


//=============================================================================
