//=============================================================================
//                                                                            
//                               OpenMesh                                     
//        Copyright (C) 2003 by Computer Graphics Group, RWTH Aachen          
//                           www.openmesh.org                                 
//                                                                            
//-----------------------------------------------------------------------------
//                                                                            
//                                License                                     
//                                                                            
//   This library is free software; you can redistribute it and/or modify it 
//   under the terms of the GNU Library General Public License as published  
//   by the Free Software Foundation, version 2.                             
//                                                                             
//   This library is distributed in the hope that it will be useful, but       
//   WITHOUT ANY WARRANTY; without even the implied warranty of                
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         
//   Library General Public License for more details.                          
//                                                                            
//   You should have received a copy of the GNU Library General Public         
//   License along with this library; if not, write to the Free Software       
//   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 
//                                                                            
//-----------------------------------------------------------------------------
//                                                                            
//   $Revision: 1.2 $
//   $Date: 2005-12-21 14:00:45 $
//                                                                            
//=============================================================================


//== INCLUDES =================================================================


#include <cstdlib>

#include <OpenMesh/Core/IO/MeshIO.hh>
#include <OpenMesh/Core/Mesh/Types/TriMesh_ArrayKernelT.hh>
#include <Inventor/SoDB.h>
#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoSeparator.h>
#include <OpenMesh/Apps/IvViewer/SoOpenMeshNodeT.hh>


//== CLASS DEFINITION =========================================================


struct MyTraits : public OpenMesh::DefaultTraits
{
   VertexAttributes(OpenMesh::Attributes::Normal);
   HalfedgeAttributes(OpenMesh::Attributes::PrevHalfedge);
   FaceAttributes(OpenMesh::Attributes::Normal);
};

  
typedef OpenMesh::TriMesh_ArrayKernelT<MyTraits>  MyMesh;
typedef OpenMesh::SoOpenMeshNodeT<MyMesh>         MyNode;



//== IMPLEMENTATION ===========================================================



int main(int argc, char **argv)
{
  OpenMesh::IO::Options opt;


  Widget myWindow = SoXt::init(argv[0], "InventorViewer");
  MyNode::initClass();
  SoXtExaminerViewer *myViewer = new SoXtExaminerViewer(myWindow);

  
  // Read a mesh
  MyMesh  mesh;
  if (argc > 1 && OpenMesh::IO::read_mesh(mesh, argv[1], opt))
  {
    if (!opt.check( OpenMesh::IO::Options::FaceNormal))
      mesh.update_face_normals();

    SoSeparator* root = new SoSeparator();
    root->addChild(new MyNode(&mesh));

    myViewer->setSceneGraph(root);
  }


  myViewer->show();
  SoXt::show(myWindow);
  SoXt::mainLoop();
}


//=============================================================================
