/**
 * Aufzaehlungstyp, der die vier Himmelsrichtungen beschreibt.
 */
public enum Direction {
    N, O, S, W;

    /**
     * Definiert die Ordnung N < O < S < W.
     */
    public boolean lessThan(Direction other) {
        return this.ordinal() < other.ordinal();
    }

    /**
     * Gibt die umgedrehte Richtung zurueck.
     */
    public Direction neg() {
        switch (this) {
        case N:
            return S;
        case O:
            return W;
        case S:
            return N;
        case W:
            return O;
        }
        throw new RuntimeException("invalid direction: " + this);
    }

    /**
     * Gibt die naechste Richtung der Folge N, O, S, W zurueck.
     */
    public Direction next() {
        switch (this) {
        case N:
            return O;
        case O:
            return S;
        case S:
            return W;
        case W:
            return N;
        }
        throw new RuntimeException("invalid direction: " + this);
    }
}
