% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% This script produces the statistics/data reported in the paper. 
%
% It computes average runtimes (geometric means), sparsities of patch-
% representation coefficient vectors, SSIM- and PSNR-values for the 
% reconstructions X_DOLPHIn and proj_box(R(D*A)) from DOLPHIn as well 
% as X_WF from Wirtinger Flow, over the groups of three 256x256 and 
% five 512x512 test images, respectively, and separately for each of the 
% four measurement types considered in the paper.
%
% The gathered result statistics are saved into Matlab binary files to 
% be loaded directly when needed.
%
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% This script is part of the DOLPHIn package (version 1.10)
% last modified: 06/27/2016, A. M. Tillmann
%
% You may freely use and modify the code for academic purposes, though we
% would appreciate if you could let us know (particularly should you find 
% a bug); if you use DOLPHIn for your own work, please cite the paper
%
%    "DOLPHIn -- Dictionary Learning for Phase Retrieval",
%    Andreas M. Tillmann, Yonina C. Eldar and Julien Mairal, 2016.
%    http://arxiv.org/abs/1602.02263
%
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

noTestruns = 3; % number of testruns the results were created from

pics256 = {'cameraman256';'house256';'peppers256'};
ext256  = {'.png';'.png';'.png'};
pics512 = {'lena512';'barbara512';'boat512';'fingerprint512';'mandrill512'};
ext512  = {'.png';'.png';'.png';'.png';'.png'};

meastypes = {'gauss';'gkronsymm';'gkron';'cdp'};

testtypes = {'VariantDefault_';'VariantSparsityCons_'}; % + variations...

% init. temporary storage
psnrsXk = zeros(1,noTestruns);
ssimsXk = zeros(1,noTestruns);
psnrsRDAk = zeros(1,noTestruns);
ssimsRDAk = zeros(1,noTestruns);
sparsk = zeros(1,noTestruns);
timesDOLPHInk = zeros(1,noTestruns);
psnrsX = zeros(1,max(length(pics256),length(pics512)));
ssimsX = zeros(1,max(length(pics256),length(pics512)));
psnrsRDA = zeros(1,max(length(pics256),length(pics512)));
ssimsRDA = zeros(1,max(length(pics256),length(pics512)));
psnrsXWF = zeros(1,max(length(pics256),length(pics512)));
ssimsXWF = zeros(1,max(length(pics256),length(pics512)));
spars = zeros(1,max(length(pics256),length(pics512)));
timesDOLPHIn = zeros(1,max(length(pics256),length(pics512)));
timesWF = zeros(1,max(length(pics256),length(pics512)));

% init. output data variables
means256.meastypes = meastypes;
means256.testtypes = testtypes;
means256.psnrsX = cell(length(testtypes),length(meastypes));
means256.ssimsX = cell(length(testtypes),length(meastypes));
means256.spars = cell(length(testtypes),length(meastypes));
means256.timesDOLPHIn = cell(length(testtypes),length(meastypes));
means256.psnrsRDA = cell(length(testtypes),length(meastypes));
means256.ssimsRDA = cell(length(testtypes),length(meastypes));
means256.psnrsXWF = cell(length(testtypes),length(meastypes));
means256.ssimsXWF = cell(length(testtypes),length(meastypes));
means256.timesWF = cell(length(testtypes),length(meastypes));
means512.meastypes = meastypes;
means512.testtypes = testtypes;
means512.psnrsX = cell(length(testtypes),length(meastypes));
means512.ssimsX = cell(length(testtypes),length(meastypes));
means512.spars = cell(length(testtypes),length(meastypes));
means512.timesDOLPHIn = cell(length(testtypes),length(meastypes));
means512.psnrsRDA = cell(length(testtypes),length(meastypes));
means512.ssimsRDA = cell(length(testtypes),length(meastypes));
means512.psnrsXWF = cell(length(testtypes),length(meastypes));
means512.ssimsXWF = cell(length(testtypes),length(meastypes));
means512.timesWF = cell(length(testtypes),length(meastypes));

means256_0_75_0_1_1_1.meastypes = meastypes;
means256_0_75_0_1_1_1.psnrsX = cell(length(meastypes));
means256_0_75_0_1_1_1.ssimsX = cell(length(meastypes));
means256_0_75_0_1_1_1.spars = cell(length(meastypes));
means256_0_75_0_1_1_1.timesDOLPHIn = cell(length(meastypes));
means256_0_75_0_1_1_1.psnrsRDA = cell(length(meastypes));
means256_0_75_0_1_1_1.ssimsRDA = cell(length(meastypes));
means256_0_75_0_1_1_1.psnrsXWF = cell(length(meastypes));
means256_0_75_0_1_1_1.ssimsXWF = cell(length(meastypes));
means256_0_75_0_1_1_1.timesWF = cell(length(meastypes));
means256_75_0_0_1_1_1.meastypes = meastypes;
means256_75_0_0_1_1_1.psnrsX = cell(length(meastypes));
means256_75_0_0_1_1_1.ssimsX = cell(length(meastypes));
means256_75_0_0_1_1_1.spars = cell(length(meastypes));
means256_75_0_0_1_1_1.timesDOLPHIn = cell(length(meastypes));
means256_75_0_0_1_1_1.psnrsRDA = cell(length(meastypes));
means256_75_0_0_1_1_1.ssimsRDA = cell(length(meastypes));
means256_75_0_0_1_1_1.psnrsXWF = cell(length(meastypes));
means256_75_0_0_1_1_1.ssimsXWF = cell(length(meastypes));
means256_75_0_0_1_1_1.timesWF = cell(length(meastypes));
means256_25_50.meastypes = meastypes;
means256_25_50.psnrsX = cell(2,3,3,2,length(meastypes));
means256_25_50.ssimsX = cell(2,3,3,2,length(meastypes));
means256_25_50.spars = cell(2,3,3,2,length(meastypes));
means256_25_50.timesDOLPHIn = cell(2,3,3,2,length(meastypes));
means256_25_50.psnrsRDA = cell(2,3,3,2,length(meastypes));
means256_25_50.ssimsRDA = cell(2,3,3,2,length(meastypes));
means256_25_50.psnrsXWF = cell(2,3,3,2,length(meastypes));
means256_25_50.ssimsXWF = cell(2,3,3,2,length(meastypes));
means256_25_50.timesWF = cell(2,3,3,2,length(meastypes));
means256_25_50.abcd = cell(2,3,3,2,length(meastypes));
means512_0_75_0_1_1_1.meastypes = meastypes;
means512_0_75_0_1_1_1.psnrsX = cell(length(meastypes));
means512_0_75_0_1_1_1.ssimsX = cell(length(meastypes));
means512_0_75_0_1_1_1.spars = cell(length(meastypes));
means512_0_75_0_1_1_1.timesDOLPHIn = cell(length(meastypes));
means512_0_75_0_1_1_1.psnrsRDA = cell(length(meastypes));
means512_0_75_0_1_1_1.ssimsRDA = cell(length(meastypes));
means512_0_75_0_1_1_1.psnrsXWF = cell(length(meastypes));
means512_0_75_0_1_1_1.ssimsXWF = cell(length(meastypes));
means512_0_75_0_1_1_1.timesWF = cell(length(meastypes));
means512_75_0_0_1_1_1.meastypes = meastypes;
means512_75_0_0_1_1_1.psnrsX = cell(length(meastypes));
means512_75_0_0_1_1_1.ssimsX = cell(length(meastypes));
means512_75_0_0_1_1_1.spars = cell(length(meastypes));
means512_75_0_0_1_1_1.timesDOLPHIn = cell(length(meastypes));
means512_75_0_0_1_1_1.psnrsRDA = cell(length(meastypes));
means512_75_0_0_1_1_1.ssimsRDA = cell(length(meastypes));
means512_75_0_0_1_1_1.psnrsXWF = cell(length(meastypes));
means512_75_0_0_1_1_1.ssimsXWF = cell(length(meastypes));
means512_75_0_0_1_1_1.timesWF = cell(length(meastypes));
means512_25_50.meastypes = meastypes;
means512_25_50.psnrsX = cell(2,3,3,2,length(meastypes));
means512_25_50.ssimsX = cell(2,3,3,2,length(meastypes));
means512_25_50.spars = cell(2,3,3,2,length(meastypes));
means512_25_50.timesDOLPHIn = cell(2,3,3,2,length(meastypes));
means512_25_50.psnrsRDA = cell(2,3,3,2,length(meastypes));
means512_25_50.ssimsRDA = cell(2,3,3,2,length(meastypes));
means512_25_50.psnrsXWF = cell(2,3,3,2,length(meastypes));
means512_25_50.ssimsXWF = cell(2,3,3,2,length(meastypes));
means512_25_50.timesWF = cell(2,3,3,2,length(meastypes));
means512_25_50.abcd = cell(2,3,3,2,length(meastypes));

% Process results from 256x256 images:
for t=1:length(testtypes)
    for j=1:length(meastypes)
        for k=1:length(pics256)
            load(['../results/',testtypes{t},meastypes{j},'_',pics256{k},'.mat']);
            for i=1:noTestruns
                psnrsXk(i) = stat.DOLPHInStats{i}.psnrX; psnrsRDAk(i) = stat.DOLPHInStats{i}.psnrRDA; 
                ssimsXk(i) = stat.DOLPHInStats{i}.ssimX; ssimsRDAk(i) = stat.DOLPHInStats{i}.ssimRDA; 
                timesDOLPHInk(i) = stat.DOLPHInStats{i}.timeTotal;
                sparsk(i) = stat.DOLPHInStats{i}.nnzA;
            end
            psnrsX(k) = mean(psnrsXk); psnrsRDA(k) = mean(psnrsRDAk); 
            ssimsX(k) = mean(ssimsXk); ssimsRDA(k) = mean(ssimsRDAk); 
            timesDOLPHIn(k) = geomean(timesDOLPHInk);
            spars(k) = mean(sparsk);
            ssimsXWF(k) = mean(stat.ssimXwf);
            psnrsXWF(k) = mean(stat.psnrXwf);
            timesWF(k) = geomean(stat.timeWF);
        end
        means256.psnrsX{t}{j} = mean(psnrsX(1:length(pics256)));
        means256.ssimsX{t}{j} = mean(ssimsX(1:length(pics256)));
        means256.psnrsRDA{t}{j} = mean(psnrsRDA(1:length(pics256)));
        means256.ssimsRDA{t}{j} = mean(ssimsRDA(1:length(pics256)));
        means256.psnrsXWF{t}{j} = mean(psnrsXWF(1:length(pics256)));
        means256.ssimsXWF{t}{j} = mean(ssimsXWF(1:length(pics256)));
        means256.timesDOLPHIn{t}{j} = geomean(timesDOLPHIn(1:length(pics256)));
        means256.timesWF{t}{j} = geomean(timesWF(1:length(pics256)));
        means256.spars{t}{j} = mean(spars(1:length(pics256)));
    end
    
    if( t == 1 ) % VariantDefault_variations       
        %% _0_75_0_1_1_1
        for j=1:length(meastypes)
            for k=1:length(pics256)
                load(['../results/',testtypes{t},meastypes{j},'_',pics256{k},'_0_75_0_1_1_1.mat']);
                for i=1:noTestruns
                    psnrsXk(i) = stat.DOLPHInStats{i}.psnrX; psnrsRDAk(i) = stat.DOLPHInStats{i}.psnrRDA;
                    ssimsXk(i) = stat.DOLPHInStats{i}.ssimX; ssimsRDAk(i) = stat.DOLPHInStats{i}.ssimRDA;
                    timesDOLPHInk(i) = stat.DOLPHInStats{i}.timeTotal;
                    sparsk(i) = stat.DOLPHInStats{i}.nnzA;
                end
                psnrsX(k) = mean(psnrsXk); psnrsRDA(k) = mean(psnrsRDAk);
                ssimsX(k) = mean(ssimsXk); ssimsRDA(k) = mean(ssimsRDAk);
                timesDOLPHIn(k) = geomean(timesDOLPHInk);
                spars(k) = mean(sparsk);
                ssimsXWF(k) = mean(stat.ssimXwf);
                psnrsXWF(k) = mean(stat.psnrXwf);
                timesWF(k) = geomean(stat.timeWF);
            end
            means256_0_75_0_1_1_1.psnrsX{j} = mean(psnrsX(1:length(pics256)));
            means256_0_75_0_1_1_1.ssimsX{j} = mean(ssimsX(1:length(pics256)));
            means256_0_75_0_1_1_1.psnrsRDA{j} = mean(psnrsRDA(1:length(pics256)));
            means256_0_75_0_1_1_1.ssimsRDA{j} = mean(ssimsRDA(1:length(pics256)));
            means256_0_75_0_1_1_1.psnrsXWF{j} = mean(psnrsXWF(1:length(pics256)));
            means256_0_75_0_1_1_1.ssimsXWF{j} = mean(ssimsXWF(1:length(pics256)));
            means256_0_75_0_1_1_1.timesDOLPHIn{j} = geomean(timesDOLPHIn(1:length(pics256)));
            means256_0_75_0_1_1_1.timesWF{j} = geomean(timesWF(1:length(pics256)));
            means256_0_75_0_1_1_1.spars{j} = mean(spars(1:length(pics256)));
        end
        %% _75_0_0_1_1_1
        for j=1:length(meastypes)
            for k=1:length(pics256)
                load(['../results/',testtypes{t},meastypes{j},'_',pics256{k},'_75_0_0_1_1_1.mat']);
                for i=1:noTestruns
                    psnrsXk(i) = stat.DOLPHInStats{i}.psnrX; psnrsRDAk(i) = stat.DOLPHInStats{i}.psnrRDA;
                    ssimsXk(i) = stat.DOLPHInStats{i}.ssimX; ssimsRDAk(i) = stat.DOLPHInStats{i}.ssimRDA;
                    timesDOLPHInk(i) = stat.DOLPHInStats{i}.timeTotal;
                    sparsk(i) = stat.DOLPHInStats{i}.nnzA;
                end
                psnrsX(k) = mean(psnrsXk); psnrsRDA(k) = mean(psnrsRDAk);
                ssimsX(k) = mean(ssimsXk); ssimsRDA(k) = mean(ssimsRDAk);
                timesDOLPHIn(k) = geomean(timesDOLPHInk);
                spars(k) = mean(sparsk);
                ssimsXWF(k) = mean(stat.ssimXwf);
                psnrsXWF(k) = mean(stat.psnrXwf);
                timesWF(k) = geomean(stat.timeWF);
            end
            means256_75_0_0_1_1_1.psnrsX{j} = mean(psnrsX(1:length(pics256)));
            means256_75_0_0_1_1_1.ssimsX{j} = mean(ssimsX(1:length(pics256)));
            means256_75_0_0_1_1_1.psnrsRDA{j} = mean(psnrsRDA(1:length(pics256)));
            means256_75_0_0_1_1_1.ssimsRDA{j} = mean(ssimsRDA(1:length(pics256)));
            means256_75_0_0_1_1_1.psnrsXWF{j} = mean(psnrsXWF(1:length(pics256)));
            means256_75_0_0_1_1_1.ssimsXWF{j} = mean(ssimsXWF(1:length(pics256)));
            means256_75_0_0_1_1_1.timesDOLPHIn{j} = geomean(timesDOLPHIn(1:length(pics256)));
            means256_75_0_0_1_1_1.timesWF{j} = geomean(timesWF(1:length(pics256)));
            means256_75_0_0_1_1_1.spars{j} = mean(spars(1:length(pics256)));
        end
        %% _25_50_a_b_c_d :
        for a = 0:1
            for b = 1:2:5
                for c = 1:2:5
                    for d = 1:2:3
                        if( a+b+c+d <= 3 )
                            means256_25_50.psnrsX{a+1}{ceil(b/2)}{ceil(c/2)}{ceil(d/2)}{j} = [];
                            means256_25_50.ssimsX{a+1}{ceil(b/2)}{ceil(c/2)}{ceil(d/2)}{j} = [];
                            means256_25_50.psnrsRDA{a+1}{ceil(b/2)}{ceil(c/2)}{ceil(d/2)}{j} = [];
                            means256_25_50.ssimsRDA{a+1}{ceil(b/2)}{ceil(c/2)}{ceil(d/2)}{j} = [];
                            means256_25_50.psnrsXWF{a+1}{ceil(b/2)}{ceil(c/2)}{ceil(d/2)}{j} = [];
                            means256_25_50.ssimsXWF{a+1}{ceil(b/2)}{ceil(c/2)}{ceil(d/2)}{j} = [];
                            means256_25_50.timesDOLPHIn{a+1}{ceil(b/2)}{ceil(c/2)}{ceil(d/2)}{j} = [];
                            means256_25_50.timesWF{a+1}{ceil(b/2)}{ceil(c/2)}{ceil(d/2)}{j} = [];
                            means256_25_50.spars{a+1}{ceil(b/2)}{ceil(c/2)}{ceil(d/2)}{j} = [];
                            means256_25_50.abcd{a+1}{ceil(b/2)}{ceil(c/2)}{ceil(d/2)}{j} = [a,b,c,d];
                        end
                        if( a+b+c+d > 3 ) % exludes the case a=0,b=c=d=1 (overall DOLPHIn default)
                            for j=1:length(meastypes)
                                for k=1:length(pics256)
                                    load(['../results/',testtypes{t},meastypes{j},'_',pics256{k},sprintf('_25_50_%d_%d_%d_%d',a,b,c,d),'.mat']);
                                    for i=1:noTestruns
                                        psnrsXk(i) = stat.DOLPHInStats{i}.psnrX; psnrsRDAk(i) = stat.DOLPHInStats{i}.psnrRDA;
                                        ssimsXk(i) = stat.DOLPHInStats{i}.ssimX; ssimsRDAk(i) = stat.DOLPHInStats{i}.ssimRDA;
                                        timesDOLPHInk(i) = stat.DOLPHInStats{i}.timeTotal;
                                        sparsk(i) = stat.DOLPHInStats{i}.nnzA;
                                    end
                                    psnrsX(k) = mean(psnrsXk); psnrsRDA(k) = mean(psnrsRDAk);
                                    ssimsX(k) = mean(ssimsXk); ssimsRDA(k) = mean(ssimsRDAk);
                                    timesDOLPHIn(k) = geomean(timesDOLPHInk);
                                    spars(k) = mean(sparsk);
                                    ssimsXWF(k) = mean(stat.ssimXwf);
                                    psnrsXWF(k) = mean(stat.psnrXwf);
                                    timesWF(k) = geomean(stat.timeWF);
                                end
                                means256_25_50.psnrsX{a+1}{ceil(b/2)}{ceil(c/2)}{ceil(d/2)}{j} = mean(psnrsX(1:length(pics256)));
                                means256_25_50.ssimsX{a+1}{ceil(b/2)}{ceil(c/2)}{ceil(d/2)}{j} = mean(ssimsX(1:length(pics256)));
                                means256_25_50.psnrsRDA{a+1}{ceil(b/2)}{ceil(c/2)}{ceil(d/2)}{j} = mean(psnrsRDA(1:length(pics256)));
                                means256_25_50.ssimsRDA{a+1}{ceil(b/2)}{ceil(c/2)}{ceil(d/2)}{j} = mean(ssimsRDA(1:length(pics256)));
                                means256_25_50.psnrsXWF{a+1}{ceil(b/2)}{ceil(c/2)}{ceil(d/2)}{j} = mean(psnrsXWF(1:length(pics256)));
                                means256_25_50.ssimsXWF{a+1}{ceil(b/2)}{ceil(c/2)}{ceil(d/2)}{j} = mean(ssimsXWF(1:length(pics256)));
                                means256_25_50.timesDOLPHIn{a+1}{ceil(b/2)}{ceil(c/2)}{ceil(d/2)}{j} = geomean(timesDOLPHIn(1:length(pics256)));
                                means256_25_50.timesWF{a+1}{ceil(b/2)}{ceil(c/2)}{ceil(d/2)}{j} = geomean(timesWF(1:length(pics256)));
                                means256_25_50.spars{a+1}{ceil(b/2)}{ceil(c/2)}{ceil(d/2)}{j} = mean(spars(1:length(pics256)));
                                means256_25_50.abcd{a+1}{ceil(b/2)}{ceil(c/2)}{ceil(d/2)}{j} = [a,b,c,d];
                            end
                        end
                    end
                end
            end
        end
    end
    
    fprintf('Processed test results for 256x256 images <%s>\n',testtypes{t});
end

% Process results from 512x512 images:
for t=1:length(testtypes)
    for j=1:length(meastypes)
        for k=1:length(pics512)
            load(['../results/',testtypes{t},meastypes{j},'_',pics512{k},'.mat']);
            for i=1:noTestruns
                psnrsXk(i) = stat.DOLPHInStats{i}.psnrX; psnrsRDAk(i) = stat.DOLPHInStats{i}.psnrRDA; 
                ssimsXk(i) = stat.DOLPHInStats{i}.ssimX; ssimsRDAk(i) = stat.DOLPHInStats{i}.ssimRDA; 
                timesDOLPHInk(i) = stat.DOLPHInStats{i}.timeTotal;
                sparsk(i) = stat.DOLPHInStats{i}.nnzA;
            end
            psnrsX(k) = mean(psnrsXk); psnrsRDA(k) = mean(psnrsRDAk); 
            ssimsX(k) = mean(ssimsXk); ssimsRDA(k) = mean(ssimsRDAk); 
            timesDOLPHIn(k) = geomean(timesDOLPHInk);
            spars(k) = mean(sparsk);
            ssimsXWF(k) = mean(stat.ssimXwf);
            psnrsXWF(k) = mean(stat.psnrXwf);
            timesWF(k) = geomean(stat.timeWF);
        end
        means512.psnrsX{t}{j} = mean(psnrsX(1:length(pics512)));
        means512.ssimsX{t}{j} = mean(ssimsX(1:length(pics512)));
        means512.psnrsRDA{t}{j} = mean(psnrsRDA(1:length(pics512)));
        means512.ssimsRDA{t}{j} = mean(ssimsRDA(1:length(pics512)));
        means512.psnrsXWF{t}{j} = mean(psnrsXWF(1:length(pics512)));
        means512.ssimsXWF{t}{j} = mean(ssimsXWF(1:length(pics512)));
        means512.timesDOLPHIn{t}{j} = geomean(timesDOLPHIn(1:length(pics512)));
        means512.timesWF{t}{j} = geomean(timesWF(1:length(pics512)));
        means512.spars{t}{j} = mean(spars(1:length(pics512)));
    end
    
    if( t == 1 ) % VariantDefault_variations       
        %% _0_75_0_1_1_1
        for j=1:length(meastypes)
            for k=1:length(pics512)
                load(['../results/',testtypes{t},meastypes{j},'_',pics512{k},'_0_75_0_1_1_1.mat']);
                for i=1:noTestruns
                    psnrsXk(i) = stat.DOLPHInStats{i}.psnrX; psnrsRDAk(i) = stat.DOLPHInStats{i}.psnrRDA;
                    ssimsXk(i) = stat.DOLPHInStats{i}.ssimX; ssimsRDAk(i) = stat.DOLPHInStats{i}.ssimRDA;
                    timesDOLPHInk(i) = stat.DOLPHInStats{i}.timeTotal;
                    sparsk(i) = stat.DOLPHInStats{i}.nnzA;
                end
                psnrsX(k) = mean(psnrsXk); psnrsRDA(k) = mean(psnrsRDAk);
                ssimsX(k) = mean(ssimsXk); ssimsRDA(k) = mean(ssimsRDAk);
                timesDOLPHIn(k) = geomean(timesDOLPHInk);
                spars(k) = mean(sparsk);
                ssimsXWF(k) = mean(stat.ssimXwf);
                psnrsXWF(k) = mean(stat.psnrXwf);
                timesWF(k) = geomean(stat.timeWF);
            end
            means512_0_75_0_1_1_1.psnrsX{j} = mean(psnrsX(1:length(pics512)));
            means512_0_75_0_1_1_1.ssimsX{j} = mean(ssimsX(1:length(pics512)));
            means512_0_75_0_1_1_1.psnrsRDA{j} = mean(psnrsRDA(1:length(pics512)));
            means512_0_75_0_1_1_1.ssimsRDA{j} = mean(ssimsRDA(1:length(pics512)));
            means512_0_75_0_1_1_1.psnrsXWF{j} = mean(psnrsXWF(1:length(pics512)));
            means512_0_75_0_1_1_1.ssimsXWF{j} = mean(ssimsXWF(1:length(pics512)));
            means512_0_75_0_1_1_1.timesDOLPHIn{j} = geomean(timesDOLPHIn(1:length(pics512)));
            means512_0_75_0_1_1_1.timesWF{j} = geomean(timesWF(1:length(pics512)));
            means512_0_75_0_1_1_1.spars{j} = mean(spars(1:length(pics512)));
        end
        %% _75_0_0_1_1_1
        for j=1:length(meastypes)
            for k=1:length(pics512)
                load(['../results/',testtypes{t},meastypes{j},'_',pics512{k},'_75_0_0_1_1_1.mat']);
                for i=1:noTestruns
                    psnrsXk(i) = stat.DOLPHInStats{i}.psnrX; psnrsRDAk(i) = stat.DOLPHInStats{i}.psnrRDA;
                    ssimsXk(i) = stat.DOLPHInStats{i}.ssimX; ssimsRDAk(i) = stat.DOLPHInStats{i}.ssimRDA;
                    timesDOLPHInk(i) = stat.DOLPHInStats{i}.timeTotal;
                    sparsk(i) = stat.DOLPHInStats{i}.nnzA;
                end
                psnrsX(k) = mean(psnrsXk); psnrsRDA(k) = mean(psnrsRDAk);
                ssimsX(k) = mean(ssimsXk); ssimsRDA(k) = mean(ssimsRDAk);
                timesDOLPHIn(k) = geomean(timesDOLPHInk);
                spars(k) = mean(sparsk);
                ssimsXWF(k) = mean(stat.ssimXwf);
                psnrsXWF(k) = mean(stat.psnrXwf);
                timesWF(k) = geomean(stat.timeWF);
            end
            means512_75_0_0_1_1_1.psnrsX{j} = mean(psnrsX(1:length(pics512)));
            means512_75_0_0_1_1_1.ssimsX{j} = mean(ssimsX(1:length(pics512)));
            means512_75_0_0_1_1_1.psnrsRDA{j} = mean(psnrsRDA(1:length(pics512)));
            means512_75_0_0_1_1_1.ssimsRDA{j} = mean(ssimsRDA(1:length(pics512)));
            means512_75_0_0_1_1_1.psnrsXWF{j} = mean(psnrsXWF(1:length(pics512)));
            means512_75_0_0_1_1_1.ssimsXWF{j} = mean(ssimsXWF(1:length(pics512)));
            means512_75_0_0_1_1_1.timesDOLPHIn{j} = geomean(timesDOLPHIn(1:length(pics512)));
            means512_75_0_0_1_1_1.timesWF{j} = geomean(timesWF(1:length(pics512)));
            means512_75_0_0_1_1_1.spars{j} = mean(spars(1:length(pics512)));
        end
        %% _25_50_a_b_c_d :
        for a = 0:1
            for b = 1:2:5
                for c = 1:2:5
                    for d = 1:2:3
                        if( a+b+c+d <= 3 )
                            means512_25_50.psnrsX{a+1}{ceil(b/2)}{ceil(c/2)}{ceil(d/2)}{j} = [];
                            means512_25_50.ssimsX{a+1}{ceil(b/2)}{ceil(c/2)}{ceil(d/2)}{j} = [];
                            means512_25_50.psnrsRDA{a+1}{ceil(b/2)}{ceil(c/2)}{ceil(d/2)}{j} = [];
                            means512_25_50.ssimsRDA{a+1}{ceil(b/2)}{ceil(c/2)}{ceil(d/2)}{j} = [];
                            means512_25_50.psnrsXWF{a+1}{ceil(b/2)}{ceil(c/2)}{ceil(d/2)}{j} = [];
                            means512_25_50.ssimsXWF{a+1}{ceil(b/2)}{ceil(c/2)}{ceil(d/2)}{j} = [];
                            means512_25_50.timesDOLPHIn{a+1}{ceil(b/2)}{ceil(c/2)}{ceil(d/2)}{j} = [];
                            means512_25_50.timesWF{a+1}{ceil(b/2)}{ceil(c/2)}{ceil(d/2)}{j} = [];
                            means512_25_50.spars{a+1}{ceil(b/2)}{ceil(c/2)}{ceil(d/2)}{j} = [];
                            means512_25_50.abcd{a+1}{ceil(b/2)}{ceil(c/2)}{ceil(d/2)}{j} = [a,b,c,d];
                        end
                        if( a+b+c+d > 3 ) % exludes the case a=0,b=c=d=1 (overall DOLPHIn default)
                            for j=1:length(meastypes)
                                for k=1:length(pics512)
                                    load(['../results/',testtypes{t},meastypes{j},'_',pics512{k},sprintf('_25_50_%d_%d_%d_%d',a,b,c,d),'.mat']);
                                    for i=1:noTestruns
                                        psnrsXk(i) = stat.DOLPHInStats{i}.psnrX; psnrsRDAk(i) = stat.DOLPHInStats{i}.psnrRDA;
                                        ssimsXk(i) = stat.DOLPHInStats{i}.ssimX; ssimsRDAk(i) = stat.DOLPHInStats{i}.ssimRDA;
                                        timesDOLPHInk(i) = stat.DOLPHInStats{i}.timeTotal;
                                        sparsk(i) = stat.DOLPHInStats{i}.nnzA;
                                    end
                                    psnrsX(k) = mean(psnrsXk); psnrsRDA(k) = mean(psnrsRDAk);
                                    ssimsX(k) = mean(ssimsXk); ssimsRDA(k) = mean(ssimsRDAk);
                                    timesDOLPHIn(k) = geomean(timesDOLPHInk);
                                    spars(k) = mean(sparsk);
                                    ssimsXWF(k) = mean(stat.ssimXwf);
                                    psnrsXWF(k) = mean(stat.psnrXwf);
                                    timesWF(k) = geomean(stat.timeWF);
                                end
                                means512_25_50.psnrsX{a+1}{ceil(b/2)}{ceil(c/2)}{ceil(d/2)}{j} = mean(psnrsX(1:length(pics512)));
                                means512_25_50.ssimsX{a+1}{ceil(b/2)}{ceil(c/2)}{ceil(d/2)}{j} = mean(ssimsX(1:length(pics512)));
                                means512_25_50.psnrsRDA{a+1}{ceil(b/2)}{ceil(c/2)}{ceil(d/2)}{j} = mean(psnrsRDA(1:length(pics512)));
                                means512_25_50.ssimsRDA{a+1}{ceil(b/2)}{ceil(c/2)}{ceil(d/2)}{j} = mean(ssimsRDA(1:length(pics512)));
                                means512_25_50.psnrsXWF{a+1}{ceil(b/2)}{ceil(c/2)}{ceil(d/2)}{j} = mean(psnrsXWF(1:length(pics512)));
                                means512_25_50.ssimsXWF{a+1}{ceil(b/2)}{ceil(c/2)}{ceil(d/2)}{j} = mean(ssimsXWF(1:length(pics512)));
                                means512_25_50.timesDOLPHIn{a+1}{ceil(b/2)}{ceil(c/2)}{ceil(d/2)}{j} = geomean(timesDOLPHIn(1:length(pics512)));
                                means512_25_50.timesWF{a+1}{ceil(b/2)}{ceil(c/2)}{ceil(d/2)}{j} = geomean(timesWF(1:length(pics512)));
                                means512_25_50.spars{a+1}{ceil(b/2)}{ceil(c/2)}{ceil(d/2)}{j} = mean(spars(1:length(pics512)));
                                means512_25_50.abcd{a+1}{ceil(b/2)}{ceil(c/2)}{ceil(d/2)}{j} = [a,b,c,d];
                            end
                        end
                    end
                end
            end
        end
    end
    
    fprintf('Processed test results for 512x512 images <%s>\n',testtypes{t});
end

save('../results/resultStatistics.mat','means256','means512',...
    'means256_0_75_0_1_1_1','means512_0_75_0_1_1_1', ...
    'means256_75_0_0_1_1_1','means512_75_0_0_1_1_1', ...
    'means256_25_50','means512_25_50');