% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Test script for DOLPHIn 
%
% Performs all experiments reported in the paper;
% for details regarding storage of results see the respective test scripts!
%
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% This script is part of the DOLPHIn package (version 1.10)
% last modified: 06/16/2016, A. M. Tillmann
%
% You may freely use and modify the code for academic purposes, though we
% would appreciate if you could let us know (particularly should you find 
% a bug); if you use DOLPHIn for your own work, please cite the paper
%
%    "DOLPHIn -- Dictionary Learning for Phase Retrieval",
%    Andreas M. Tillmann, Yonina C. Eldar and Julien Mairal, 2016.
%    http://arxiv.org/abs/1602.02263
%
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear; clc;

% run both DOLPHIn variants and Wirtinger Flow once, to warm up:
testscript_warmup;

% first run tests with standard/default DOLPHIn variant (and WF):
rng(0); % for reproducibility of results (and cross-experiment comparability)
testscript_DOLPHIn_VariantDefault;

% now run tests with sparsity-constrained DOLPHIn variant (and WF):
rng(0); % for reproducibility of results (and cross-experiment comparability)
testscript_DOLPHIn_VariantSparsityCons;

% tests with with standard/default DOLPHIn variant (and WF), trying several
% different parameter combinations:
rng(0); % for reproducibility of results (and cross-experiment comparability)
testscript_DOLPHIn_VariantDefault_variations;

% fingerprint example (grayscale):
% ... coming soon

% waldspirale example (RGB):
% ... coming soon

% mandrill example (RGB):
% ... coming soon