% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Warm-up script for DOLPHIn (default and sparsity-constrained variant) and
% Wirtinger Flow.
%
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% This script is part of the DOLPHIn package (version 1.10)
% last modified: 06/06/2016, A. M. Tillmann
%
% You may freely use and modify the code for academic purposes, though we
% would appreciate if you could let us know (particularly should you find 
% a bug); if you use DOLPHIn for your own work, please cite the paper
%
%    "DOLPHIn -- Dictionary Learning for Phase Retrieval",
%    Andreas M. Tillmann, Yonina C. Eldar and Julien Mairal, 2016.
%    http://arxiv.org/abs/1602.02263
%
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

cd ..

fprintf('Warming up...');

addpath('tools/');
fun = @fun_general_op;
data.cdptype       = 'ternary'; % type of cdp masks
data.numM          =         2; % number of cdp masks
[Xopt,Y,F,G,H,M] = instanceGenerator('images/cameraman256.png','cdp',data,[],20);
proj = @(XX)proj_box(XX);

params.verbose = 0;
[params.h,params.w] = size(Xopt); params.mY = numel(Y);
params.K1 = 1; params.K2 = 1;
params = setupParams(params); 

DOLPHIn(F,Y,fun,proj,params,Xopt);  % default DOLPHIn

clear params;
params.verbose = 0;
[params.h,params.w] = size(Xopt); params.mY = numel(Y);
params.K1 = 1; params.K2 = 1;
params.L = 4; params.overlap = 1;
params = setupParams(params);

DOLPHIn(F,Y,fun,proj,params,Xopt);  % sparsity-constrained DOLPHIn

% Wirtinger Flow:
WF_RealCons(F,Y,fun,proj,params.h,params.w,2,1,proj(rand(params.h,params.w)),0);

clear;

fprintf('done!\n\n');

cd scripts