function DCT = dict_dct(e,K)
%function DCT = dict_dct(e,K)
%
% Creates explicit 2D-DCT matrix.
%
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% This function is part of the DOLPHIn package (version 1.10)
% last modified: 02/06/2016, A. M. Tillmann
%
% You may freely use and modify the code for academic purposes, though we
% would appreciate if you could let us know (particularly should you find 
% a bug); if you use DOLPHIn for your own work, please cite the paper
%
%    "DOLPHIn -- Dictionary Learning for Phase Retrieval",
%    Andreas M. Tillmann, Yonina C. Eldar and Julien Mairal, 2016.
%    http://arxiv.org/abs/1602.02263
%
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
bb = e;
Pn = ceil(sqrt(K));
DCT = zeros(bb,Pn);
for k=0:1:Pn-1,
   V = cos((2*[0:1:bb-1]'+1)*k*pi/(2*Pn));
   if k>0, V = V-mean(V); end;
      DCT(:,k+1) = V/norm(V);
end;
DCT = kron(DCT,DCT);
