function [Yhat, grad] = fun_absfft_op(G,X,Y)
%function [Yhat, grad] = fun_absfft_op(G,X,Y)
%
% Evaluates (normalized 2D-) Fourier transform operator F at X and computes
% gradient of data-fit term 0.5*||Y-abs(F(X))||_F^2 at X, where Y are the
% orig. measurements (i.e., Y=abs(myfft(Xopt)) with Xopt the sought sol.)
%
% (Input argument G not used, included only for compatability with main
% DOLPHIn functions.)
%
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% This function is part of the DOLPHIn package (version 1.XX)
% last modified: 05/30/2016, A. M. Tillmann
%
% You may freely use and modify the code for academic purposes, though we
% would appreciate if you could let us know (particularly should you find 
% a bug); if you use DOLPHIn for your own work, please cite the paper
%
%    "DOLPHIn -- Dictionary Learning for Phase Retrieval",
%    Andreas M. Tillmann, Yonina C. Eldar and Julien Mairal, 2016.
%    http://arxiv.org/abs/1602.02263
%
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
tmp = myfft(X);
Yhat = abs(tmp);

if( nargout == 2 )
    if( nargin < 2 )
        Y = 0;
    end
    % grad of 1/2*|| Y - |fft(X)| ||^2  is (Id - P_M)*X :    
    grad = X-proj_PM(tmp,Y);
end

%% nested function: proj_PM (commonly used projection of X 
%  onto the equation abs(F(X)) = Y) :
    function projX = proj_PM(fftX,Y)
        fftXnnz = (fftX~=0);
        tX = Y;
        tX(fftXnnz) = tX(fftXnnz).*(fftX(fftXnnz)./abs(fftX(fftXnnz)));
        projX = real(myifft(tX)); % "real" to compensate for limited machine precision        
    end

end