function X = pgm_patchfit_HPR(X0,Y,S,DA,iter,beta,pars)%,ii)
% projected gradient method using HPR (Wen et al) as "projection" algo. on
% phase retrieval "constraints", minimizing the patch-fit LS term:

% init. 
X = X0;    % initial guess
j = 5;%max(5,min(30,50-ii));%25;     % number of HPR steps that serve as "projection"
%j = 30; %quite conservative choice, seems needed for several e.g. lena

%if useLSsol    
%    X = proj_box(mycol2im(D*A,[e e],size(X),1)); % LS-sol. proj. onto S+
%    X = proj_HPR2(X.*S,Y,j,S,beta); 
%else

%eta = pars.eta; % for monotone descent; doesn't work, see below

for k=1:iter     
    XminDA = myim2col(X,[pars.s1,pars.s2],pars.overlap)-DA;
    %%%%%XminDA = myim2col(imgaussfilt(X,1/k),[pars.s1 pars.s2],pars.overlap)-D*A; % smooth to reduce support thresholding effect, EXPERIMENTAL
    grad = pars.mu*mycol2im( XminDA,[pars.s1,pars.s2],[pars.h,pars.w],2*pars.overlap);
    
    %count = 1;
    %oldobj = sum(sum(XminDA.^2));
    
    % optimal stepsize w.r.t. patchfit of x after gradient step, ignoring PR constraints
    PeGrad = myim2col(grad,[pars.s1,pars.s2],pars.overlap);
    gamma = ...%1/(k); % stepsize, use 1/k for simplicity
        sum(sum( XminDA.*(PeGrad/sum(sum(PeGrad.^2))) ));  
     
    % gradient step w.r.t. patch-fit LS term:           
    X = proj_box( X - gamma*grad );  % probably overshoots constraints quite a lot -> relax/scale?
    %X = proj_box( X - proj_box(gamma*grad).*S ); % possibly improves result, overhooting reduced
    
    % "projection" via j steps of HPR (applied to X thresholded to support S):
    X = proj_HPR(X.*S,Y,j,S,beta); 
    
    % monotone descent -- doesn't work here
    %Xold = X;
    %while( true)
    %    X = proj_box( Xold - eta*grad );
    %    X = proj_HPR(X.*S,Y,j,S,beta);
    %    
    %    obj = sum(sum((myim2col(X,[pars.s1,pars.s2],pars.overlap)-D*A).^2));
    %    if( obj >= oldobj )
    %        eta = eta/2;
    %        count = count+1;
    %        disp(obj-oldobj)
    %    else
    %        eta = 1.68*eta;
    %        break;
    %    end
    %    if( count == 100 )
    %        break;
    %    end        
    %end
    
    %%%%%S = sign(imgaussfilt(X,2)); % iterative supp. estimate refinement, EXPERIMENTAL    
end
%end
