function X = proj_HPR(X0,Y,iter,S,beta)
%function X = proj_HPR(X0,Y,iter,S,beta)
%
% implementation of HPR phase retrieval algorithm 
% as described in Wen et al. (2012),
%    "Alternating Direction Methods for Classical 
%     and Ptychographic Phase Retrieval",
% Inverse Problem 28(11) 115010
%
% with minor modifications, and specialized to 
% real-valued [0,1]-box-constrained X
%
% Input: X0 - initial guess
%        Y  - Fourier magnitude measurements (Y=|myfft(Xopt)|)
%        iter - iteration number
%        S  - binary support mask
%        beta - relaxation parameter of HPR method
%
X = X0;
% normalize initial guess to have same energy as Fourier magnitude measurements:
%X = (X./norm(X,'fro')).*norm(Y,'fro'); % not in paper; myfft doesn't change norm!          % is this even correct?

if nargin < 3
    iter = 10; % used fixed iter number for now; in future: perhaps employ E_S+ criterion?
end
if nargin < 4
    S = 1; % no user-provided support info => nonzeros may be anywhere 
end
if nargin < 5
    beta = 0.9; % value seems to be used commonly
end

% x^{k+1} = ( (1 + β)P_S+ P_M + I − P_S+ − βP_M ) x^{k}.
dynbeta = 0; % 0 to use constant beta
if dynbeta
    beta0 = beta;
end

for ii=1:iter
    % projection onto Fourier-magnitude constraints:
    PX = proj_PM(myfft(X),Y);
        
    % HPR step, from orig. HPR paper (Bauschke,Combettes,Luke 2003):
    %posRX = ((1+beta)*PX >= X).*S;%=(2*PX-X >= (1-beta)*PX).*S;
    %X = PX.*posRX + (X - beta*PX).*(~posRX);
    
    if dynbeta % dynamic relax. parameter control as in Wen et al. paper
        beta = exp(-(ii/7)^3)*beta0 + 0.97*(1 - exp(-(ii/7)^3 )); 
    end
    
    X = X - beta*PX - proj_box(X.*S) + (1+beta)*proj_box(PX.*S);
        
    % display error measure E_S+:
    %fprintf('iter. %4d - error measure: %1.3e (with Y instead of PX: %1.3e)\n',ii,norm( max(0,PX.*S) - PX ,'fro')^2/norm( PX, 'fro')^2,norm( max(0,PX.*S) - PX ,'fro')^2/norm( Y, 'fro')^2);
end
% final "clean-up" -- enforce box and support constraints: 
X = proj_box(X.*S);

% nested ...
    function projX = proj_PM(fftX,Y)
        fftXnnz = (fftX~=0);
        tX = Y;
        tX(fftXnnz) = tX(fftXnnz).*(fftX(fftXnnz)./abs(fftX(fftXnnz)));
        projX = real(myifft(tX)); % "real" to compensate for limited machine precision        
    end
end