#ifndef SUMMERSCHOOLSMOOTHERPLUGIN_HH
#define SUMMERSCHOOLSMOOTHERPLUGIN_HH

#include <OpenFlipper/BasePlugin/BaseInterface.hh>
#include <OpenFlipper/BasePlugin/LoadSaveInterface.hh>
#include <OpenFlipper/BasePlugin/ToolboxInterface.hh>
#include <OpenFlipper/common/Types.hh>

#include <ObjectTypes/TriangleMesh/TriangleMesh.hh>

#include "./SummerSchoolSmootherToolboxWidget.hh"

class SummerSchoolSmootherPlugin: public QObject,
		BaseInterface,
		LoadSaveInterface,
		ToolboxInterface {
	Q_OBJECT
	Q_INTERFACES(BaseInterface)
	Q_INTERFACES (LoadSaveInterface)
	Q_INTERFACES (ToolboxInterface)

#if QT_VERSION >= 0x050000
Q_PLUGIN_METADATA(IID "org.OpenFlipper.Plugins.Plugin-SummerSchoolSmootherPlugin")
#endif

public:

	enum WeightingType {
		UNIFORM, COTANGENT
	};

        SummerSchoolSmootherPlugin() :
		gui_(NULL),
		weighting_(UNIFORM) {
	}


        virtual ~SummerSchoolSmootherPlugin() {
	}

signals:

	void updateView();

	void updatedObject(int _identifier, const UpdateType _type);

	void addToolbox(QString _name, QWidget* _widget);

private slots :

	// Open flipper slots
	void initializePlugin();

private slots :

	// my own slots

	void slotSmooth();

	void slotWeightingChanged(int _idx);

public slots:

	QString name() {
                return QString("SummerSchoolSmootherPlugin");
	}

	QString description() {
		return QString("Smoothes a triangle mesh.");
	}

private:

	/// Widget for Toolbox
    SummerSchoolSmootherToolboxWidget* gui_;

	WeightingType weighting_;

	void initMesh(TriMeshObject* _meshObject);

	void smooth(TriMeshObject* _meshObject);

	void lockBoundary(TriMeshObject* _meshObject);

	void computeNewPositions(TriMeshObject* _meshObject);

	// functions copied from Plugin-Curvature
	void calcWeights(TriMeshObject* _meshObject);
};

#endif
