#include "TwoStrutConfiguration.hh"

uint16_t TwoStrutConfiguration::get_h( ) const // when using for "one-strut case"
{
    return get_ha();
}

uint16_t TwoStrutConfiguration::get_l( ) const // when using for "one-strut case"
{
    return get_la();
}

uint16_t TwoStrutConfiguration::get_h( int i) const
{
  if( i == 0)
    return get_ha();
  else
    return get_hb();
}

uint16_t TwoStrutConfiguration::get_ha( ) const
{
  return comb_ & 0x3f; // lsb 6 bits (0_t..5)
}

uint16_t TwoStrutConfiguration::get_hb( ) const
{
  return 0x3f & (comb_ >> 6); // bits (6..11)
}

uint16_t TwoStrutConfiguration::get_la( ) const
{
  return (comb_ >> 12) & 0x3;
}

uint16_t TwoStrutConfiguration::get_lb( ) const
{
  return (comb_ >> 14) & 0x3;
}

bool TwoStrutConfiguration::is_direct( ) const
{
  return get_hb() > 61;
}

TwoStrutConfiguration& TwoStrutConfiguration::set_ha( uint16_t ha)
{
  comb_ &= ~(0x3f); // clear
  comb_ |= 0x3f & ha;
  return *this;
}

TwoStrutConfiguration& TwoStrutConfiguration::set_hb( uint16_t hb)
{
  comb_ &= ~(0xfc0); // clear
  comb_ |= 0xfc0 & (hb << 6);
  return *this;
}

TwoStrutConfiguration& TwoStrutConfiguration::set_la( uint16_t la)
{
  comb_ &= ~(0x3000); // clear
  comb_ |= 0x3000 & (la << 12);
  return *this;
}

TwoStrutConfiguration& TwoStrutConfiguration::set_lb( uint16_t lb)
{
  comb_ &= ~(0xc000); // clear
  comb_ |= 0xc000 & (lb << 14);
  return *this;
}

bool TwoStrutConfiguration::operator<( const TwoStrutConfiguration& rhs) const
{
  return (comb_ < rhs.comb_);
}

bool TwoStrutConfiguration::operator>( const TwoStrutConfiguration& rhs) const
{
  return (comb_ > rhs.comb_);
}

bool TwoStrutConfiguration::operator==( const TwoStrutConfiguration& rhs) const
{
  return comb_ == rhs.comb_;
}

bool TwoStrutConfiguration::operator!=( const TwoStrutConfiguration& rhs) const
{
  return comb_ != rhs.comb_;
}

uint16_t TwoStrutConfiguration::operator()() const
{
  return comb_;
}

void TwoStrutConfiguration::print_info() const
{
  std::cerr << "ha " << get_ha() << " la " << get_la() << " hb " << get_hb() << " lb " << get_lb() << std::endl;
}


std::ostream& operator<<(std::ostream& os, TwoStrutConfiguration& sp) 
{
os << sp.comb_;
return os;
}

