/*
 * Class to represent a Zometool node inbetween (connected to) two other nodes
 * the INCOMING hole and length are ha, la and
 * the OUTGOING hole and length are hb, lb
 * Note, can also be used to compactly represent a single strut (h,l) by only using first components ha, la
 * Author:  Henrik Zimmer <henrik@zimmer.to>
 *
 * Version: $Revision: 1 $
 * Date:    $date$
 */


#ifndef TWOSTRUTCONFIGURATION_HH
#define TWOSTRUTCONFIGURATION_HH

//#include <cstdint>
#include <stdint.h>
#include <iostream>


class TwoStrutConfiguration
{
  public:

    TwoStrutConfiguration( uint16_t _comb = 0) : comb_(_comb)
    { }

    TwoStrutConfiguration( uint16_t ha, uint16_t la, uint16_t hb, uint16_t lb) : comb_(0)
    {
      set_ha(ha);
      set_la(la);
      set_hb(hb);
      set_lb(lb);
    }

    // for "one-strut" case
    TwoStrutConfiguration( uint16_t ha, uint16_t la) : comb_(0)
    {
      set_ha(ha);
      set_la(la);
    }

    /** Function for the "one-strut" case */
    uint16_t get_h( ) const; // when using for "one-strut case"

    uint16_t get_l( ) const;

    /** Function for the normal "two-strut" case */
    uint16_t get_h( int i) const;

    uint16_t get_ha( ) const;

    uint16_t get_hb( ) const;

    uint16_t get_la( ) const;

    uint16_t get_lb( ) const;

    bool is_direct( ) const;

    TwoStrutConfiguration& set_ha( uint16_t ha);

    TwoStrutConfiguration& set_hb( uint16_t hb);

    TwoStrutConfiguration& set_la( uint16_t la);

    TwoStrutConfiguration& set_lb( uint16_t lb);

    bool operator<( const TwoStrutConfiguration& rhs) const;
    
    bool operator>( const TwoStrutConfiguration& rhs) const;

    bool operator==( const TwoStrutConfiguration& rhs) const;

    bool operator!=( const TwoStrutConfiguration& rhs) const;

    uint16_t operator()() const;

    void print_info() const;

    friend std::ostream& operator<<(std::ostream& os, TwoStrutConfiguration& sp);

  private:
    uint16_t comb_;
};

typedef TwoStrutConfiguration OneStrutConfiguration;

std::ostream& operator<<(std::ostream& os, TwoStrutConfiguration& sp);

#endif

