/*
 * Class for storing the directions available in the Zometool system
 * in different metrics and scalings
 * Author:  Henrik Zimmer <henrik@zimmer.to>
 * Header
 *
 * Author : $Author: zimmer $
 * Version: $rev$
 * Date:    $date$
 */

#ifndef ACG_ZOMEDIRECTIONS_HH
#define ACG_ZOMEDIRECTIONS_HH


#include "Types.hh"
#include "TwoStrutConfiguration.hh"
#include "Globals.hh"

namespace ACG {


class ZomeDirections
{

public:

  ZomeDirections( ) 
  { 
    //std::cerr << __FUNCTION__ << "\n constructing ... " << std::endl;
    setup_base_directions( );
    triple_base_directions( );
    setup_opposite_directions( );

    setup_2gammascaled_directions( );
    test_all_directions( );
    //std::cerr << __FUNCTION__ << " constructing done ... \n" << std::endl;
  }


  const std::vector< Vec3 >& dirs3d() const;
  //const std::vector< Vec3 >& dirs3ds() const;
  const std::vector< ZomeCoordZT >& dirs6d() const;

  const Vec3& dir3d( int _id) const;
  const ZomeCoordZT& dir6dZT( int _id) const;
  Zome6dIntPos dir6dvec6i( int _id) const;

  size_t id( const OneStrutConfiguration& _hl) const;
  size_t id( int _h, int _l) const;

  size_t oppid( size_t _i) const;

  size_t n_dirs( ) const;

  /// map to/from "global"/"old" directions used for growing and drawing
  void map_id_to_old_h_l( int _i, int& _h, int& _l) const;
  int  map_id_to_old_h( int _i) const;

  size_t map_to_base_range( size_t _i) const;

  bool diridfrom6d( const Zome6dIntPos& _pos, size_t& _dirid) const;

private:
  /// setup the base (62) directions and triple them
  void setup_base_directions( );
  bool test_base_directions( ); // and setup map_id_to_old_h_l_
  void triple_base_directions( );
  void setup_opposite_directions( );


  /// setup 2*gamma, integer based directions
  void setup_2gammascaled_directions( );
  bool test_2gammascaled_directions( ) const ;

  void test_all_directions( ) const;



private:
  std::vector< Vec3 > dirs3d_;
  std::vector< ZomeCoordZT > dirs6d_;

  std::vector< size_t > oppid_;

  // maps
  std::vector< std::pair< int, int > > map_id_to_old_h_l_;

  // maps 0..62*3 to first "hole"
  std::vector< size_t > map_id_to_base_range_;

  boost::unordered_map< Vec6i, size_t, VecHash > map6dtodirid_;
};


} // namespace ACG

#endif 

