//=============================================================================
//
// CLASS ZomeMeshViewerPerObjectData
//
//=============================================================================


#ifndef ZOMEMESHVIEWERPEROBJECTDATA_HH
#define ZOMEMESHVIEWERPEROBJECTDATA_HH

//== INCLUDES =================================================================


#include "Types.hh"
#include <OpenFlipper/common/perObjectData.hh>
#include "Globals.hh"
#include "ZomeDirections.hh"
#include "ZomeMetaMeshLight.hh"



//== CLASS DEFINITION =========================================================


class ZomeMeshViewerPerObjectData : public PerObjectData
{
  
public:

  class DrawMeshes
  {
    // drawmeshes, one mesh for blue, red and yellow struts each and one for the nodes
    public:
    MeshT* meshp[4]; 
    int id[4];
  };

  ZomeMeshViewerPerObjectData( PolyMesh& _metamesh, int _pid) : meta_(_metamesh), metaid_(_pid), zmm_( meta_, dirs_)
  {
    global_strut_data().clear();
    global_strut_data().reserve(3);
    global_strut_data().push_back( ACG::ZomeStrutData( RED, 1.));
    global_strut_data().push_back( ACG::ZomeStrutData( BLUE, 1.));
    global_strut_data().push_back( ACG::ZomeStrutData( YELLOW, 1.));

    for( int i = 0; i < 4; ++i)
    {
      drawmeshes_.meshp[i] = NULL;
      drawmeshes_.id[i] = -1;
    }

    // iszomemesh_ is used to distinguish PODs of PolyMeshes used to represent a "whole" ZomeMesh and PolyMeshes which are just one color component, e.g., Blue struts (these meshes dont/should not have additional color meshes as sub meshes)
    iszomemesh_ = false;
  }


  
  virtual
  ~ZomeMeshViewerPerObjectData() 
  {
  }

        ACG::ZomeMetaMeshLight& zmm() { return zmm_;}
  const ACG::ZomeMetaMeshLight& zmm() const { return zmm_;}
        ACG::ZomeDirections& directions()       { return dirs_; }
  const ACG::ZomeDirections& directions() const { return dirs_; }

  PolyMesh* meta() { return &meta_; }
  int metaid() { return metaid_; }

        DrawMeshes& drawmeshes()       { return drawmeshes_;} 
  const DrawMeshes& drawmeshes() const { return drawmeshes_;} 

  bool& iszomemesh() { return iszomemesh_; }

private:
  PolyMesh& meta_;
  int metaid_;
  ACG::ZomeDirections dirs_;
  ACG::ZomeMetaMeshLight zmm_;

  DrawMeshes drawmeshes_;

  bool iszomemesh_;
};


//=============================================================================
#endif // ZOMEMESHVIEWERPEROBJECTDATA_HH defined
//=============================================================================

