//=============================================================================
//
//  CLASS ZomeMeshViewerPlugin
//
//=============================================================================


#ifndef ZOMEMESHVIEWERPLUGIN_HH
#define ZOMEMESHVIEWERPLUGIN_HH


//== INCLUDES =================================================================

#include <QObject>
#include <OpenFlipper/common/Types.hh>
#include <OpenFlipper/BasePlugin/BaseInterface.hh>
#include <OpenFlipper/BasePlugin/ToolboxInterface.hh>
#include <OpenFlipper/BasePlugin/LoadSaveInterface.hh>
#include <OpenFlipper/BasePlugin/AboutInfoInterface.hh>
#include <OpenFlipper/BasePlugin/RPCInterface.hh>

#include "Types.hh"
#include "ZomeMeshViewerToolbar.hh"
#include "ZomeMeshViewerPerObjectData.hh"
#include "ZomeMetaMeshLight.hh"

//== CLASS DEFINITION =========================================================


class ZomeMeshViewerPlugin : public QObject, BaseInterface, ToolboxInterface, LoadSaveInterface, AboutInfoInterface, RPCInterface
{
  Q_OBJECT
  Q_INTERFACES(BaseInterface)
  Q_INTERFACES(ToolboxInterface)
  Q_INTERFACES(LoadSaveInterface)
  Q_INTERFACES(AboutInfoInterface)
  Q_INTERFACES(RPCInterface)

#if QT_VERSION >= 0x050000
  Q_PLUGIN_METADATA(IID "org.OpenFlipper.Plugins.Plugin-ZomeMeshViewer")
#endif


  // typedef for easy access
  typedef ACG::ZomeMetaMeshLight ZMM;
  typedef ZomeMeshViewerPerObjectData   POD;

signals:
  void updateView();
  void updatedObject(int _identifier, const UpdateType& _type);
  
  // ToolboxInterface
  void addToolbox( QString _name  , QWidget* _widget );   

  // LoadSaveInterface
  void addEmptyObject( DataType _type, int& _id);

  // AboutInfoInterface
  void addAboutInfo( QString _text, QString _tabname);

private slots:

  // initialization functions
  void initializePlugin();
  void pluginsInitialized();

  // Button slots
  void slot_load( );
  void slot_draw( );

  // Export to vZome VEF format (c) Scott Vorthmann
  void slot_export_vzome( );

private:
  
  void create_zomemesh( PolyMeshObject*& _polymeshobj, int& _polymeshid, PolyMesh*& _polymesh );

public :

  ZomeMeshViewerPlugin();
  ~ZomeMeshViewerPlugin();

  QString name() { return (QString("ZomeMeshViewer")); };
  QString description( ) { return (QString("View a ZomeMesh")); }; 

private :


  // return name of per object data
  const char * pod_name() { return "ZOMEMESHVIEWER_PER_OBJECT_DATA";}

  // get ZomeTool object for a given object
  ZMM* get_ZMM( BaseObjectData* _object );
  POD* get_POD( BaseObjectData* _object );
  
private :
  /// Widget for Toolbox
  ZomeMeshViewerToolbar* tool_;

};


//=============================================================================
#endif // ZOMEMESHVIEWERPLUGIN_HH defined
//=============================================================================

