/*
 * Zometool MetaMesh containing the Zometool nodes and struts
 * Author:  Henrik Zimmer <henrik@zimmer.to>
 * Header
 *
 * Author : $Author: zimmer $
 * Version: $rev$
 * Date:    $date$
 */

#ifndef ACG_ZOMEMETAMESHLIGHT_HH
#define ACG_ZOMEMETAMESHLIGHT_HH


#include "Types.hh"
#include "ZomeDirections.hh"

#include <string>
#include <sstream>


namespace ACG {


typedef std::bitset<62> NodeHoleBits;
typedef std::bitset<62>::reference NodeHoleBit;

class ZomeMetaMeshLight
{

public:


  ZomeMetaMeshLight( PolyMesh& _metamesh, const ZomeDirections& _dirs) : metamesh_(_metamesh), dirs_(_dirs)
  { 
    //std::cerr << __FUNCTION__ << "\n constructing ... " << std::endl;
    add_properties(); 
    //std::cerr << __FUNCTION__ << " constructing done ... \n" << std::endl;
  }

  ~ZomeMetaMeshLight( )
  { 
    //std::cerr << __FUNCTION__ << "\n destructing ... " << std::endl;
    rem_properties(); 
    //std::cerr << __FUNCTION__ << " destructing done ... " << std::endl;
  }

  void set_scale( Scalar _scale) { scale_ = _scale; }
  void set_origin( Vec3 _origin) { origin_ = _origin; }

  Scalar scale() { return scale_; }
  Vec3 origin() { return origin_; }

  /// transform from integer coordinates in 2*gamma space to real coordinates (replaced)
  Vec3 transform_to_real( const Zome6dIntPos& _pos6);
  void transform_to_real( );

  void get_oriented_edge_end_vertices( const EH& _eh, VH& _vhi, VH& _vhj) const;
  void get_oriented_edge_halfedge( const EH& _eh, HEH& _heh) const;


  /**! setup (tag) used holes of nodes based on the dirid of outgoing halfedges **/
  void setup_nodehole_bits( );

  //void save( std::string _filenamewoending);
  void load( std::string _filenamewoending, int _type = 1);
  void load_twoparts( std::string _filenamewoending);
  void load_zipparts( std::string _filenamewoending);
  void export_vzome( std::string _filenamewoending);

  const Zome6dIntPos& pos( int _vid) const { return metamesh_.property( metanodeposprop_, VH(_vid)); }
        Zome6dIntPos& pos( int _vid)       { return metamesh_.property( metanodeposprop_, VH(_vid)); }
  const Zome6dIntPos& pos( VH _vh) const { return metamesh_.property( metanodeposprop_, _vh); }
        Zome6dIntPos& pos( VH _vh)       { return metamesh_.property( metanodeposprop_, _vh); }

  const Vec3 realpos( int _vid) const { return metamesh_.point( VH(_vid)); }

  const PolyMesh& metamesh() const { return metamesh_; }
        PolyMesh& metamesh()       { return metamesh_; }

  // oriented heh from vhi to vhj with vhi < vhj is stored at edge
        size_t& dirid( const EH& _eh)       { return metamesh_.property( edgediridprop_, _eh); }
  const size_t& dirid( const EH& _eh) const { return metamesh_.property( edgediridprop_, _eh); }
  size_t dirid( const HEH& _heh) const 
  {
    HEH heh0( metamesh_.halfedge_handle( metamesh_.edge_handle( _heh), 0));
    if( heh0 == _heh)
      return dirid( metamesh_.edge_handle( _heh));
    else
      return dirs_.oppid(dirid( metamesh_.edge_handle( _heh)));
  }
  void set_dirid( const HEH& _heh, size_t _dirid)
  {
    HEH heh0( metamesh_.halfedge_handle( metamesh_.edge_handle( _heh), 0));
    if( heh0 == _heh)
      dirid( metamesh_.edge_handle( _heh)) = _dirid;
    else
      dirid( metamesh_.edge_handle( _heh)) = dirs_.oppid(_dirid);
  }

  // String manipulation helpter (code from stackoverflow.com TODO outsource to a utils-class)
  std::vector<std::string> &split(const std::string &s, char delim, std::vector<std::string> &elems);
  std::vector<std::string> split(const std::string &s, char delim);

  const NodeHoleBit hole( VH _vh, int _h) const { return metamesh_.property( propv_nodeholes_, _vh)[_h]; }
        NodeHoleBit hole( VH _vh, int _h)       { return metamesh_.property( propv_nodeholes_, _vh)[_h]; }
        NodeHoleBits& hole( VH _vh)       { return metamesh_.property( propv_nodeholes_, _vh); }

private:
  ////////////////////////////////////////////////////////
  ///// Initialization
  ////////////////////////////////////////////////////////

  void add_properties( );
  void rem_properties( );

  // Helpers
private:
  PolyMesh& metamesh_;
  const ZomeDirections &dirs_;

  Scalar scale_;
  Vec3 origin_;


  OpenMesh::VPropHandleT< NodeHoleBits > propv_nodeholes_;

  // Property storing zomedirection (id) of an edge, oriented along halfedge 0
  OpenMesh::EPropHandleT< size_t > edgediridprop_;

  // Property storing the 6d integer positions of the node in 2*gamma space
  OpenMesh::VPropHandleT< Vec6i > metanodeposprop_;


};


} // namespace ACG
#endif 



