//=============================================================================
//
//  CLASS ZomeNode
//
//=============================================================================


#ifndef ACG_ZOMENODET_HH
#define ACG_ZOMENODET_HH


//== INCLUDES =================================================================
#include "Types.hh"

#include "MemoryInclude.hh"

#include "ZomeNodeData.hh"


//== FORWARDDECLARATIONS ======================================================

//== NAMESPACES ===============================================================

namespace ACG {

//== CLASS DEFINITION =========================================================



	      
/** \class ZomeNode ZomeNodeT.hh <ACG/.../ZomeNodeT.hh>

    Brief Description.
  
    A more elaborate description follows.
*/



class ZomeNode
{
public:

  /// Constructor
  ZomeNode( const ZomeNodeData* _data = NULL, Vec3 _pos = Vec3(0.,0.,0.), int _nodeid = -1) : data_(_data), pos_(_pos), nodeid_(_nodeid)
  {
  }
 
  ZomeNode( const ZomeNode& _rhs) : data_(_rhs.data_), pos_(_rhs.pos_), nodeid_(_rhs.nodeid_)
  {
  }

  ZomeNode& operator=( const ZomeNode& _rhs)
  {
    data_ = _rhs.data_;
    pos_  = _rhs.pos_;
    normal_ = _rhs.normal_;
    nodeid_ = _rhs.nodeid_;
    return *this;
  }
  /// Destructor
  ~ZomeNode() 
  {
  }

  /// position of node center
  const Vec3& pos() const { return pos_; }
        Vec3& pos()       { return pos_; }
  /// node id
  const int& id() const { return nodeid_; }
        int& id()       { return nodeid_; }

  /// quite ugly, normal of underlying mesh for orientation
  const Vec3& normal() const { return normal_; }
        Vec3& normal()       { return normal_; }
  EdgeType type( int _i) const { return data_->type( _i); }
  void test();

  //const std::bitset<62>& used_holes_mask( ) const { return usedholes_; }
  //      std::bitset<62>& used_holes_mask( )       { return usedholes_; }
  // bool hole_used( int _i) const { return usedholes_[_i]; }
  //bool& hole_used( int _i) { return usedholes_[_i]; }

  const ZomeNodeData& nodedata() const { return *data_; }
  void set_nodedata_pointer( ZomeNodeData* _pt) { data_ = _pt; }

  void print_info() const;
private:
  
  const ZomeNodeData* data_;

  Vec3 pos_;
  Vec3 normal_;
  int nodeid_;

  //std::vector< ZomeStrut* > edges_;
  // 62 edges (check active flag for usage)
  //std::bitset<62> usedholes_; // better to use a counter (0, 1, 2) // better to use a counter (0, 1, 2)
  
  //std::bitset<62> locknodes_;

};


//=============================================================================
} // namespace ACG
//=============================================================================
//=============================================================================
#endif // ACG_ZOMENODET_HH defined
//=============================================================================

