//=============================================================================
//
//  CLASS ZomeNodeData - IMPLEMENTATION
//
//=============================================================================

#define ACG_ZOMENODEDATAT_C

//== INCLUDES =================================================================

#include "ZomeNodeData.hh"

//== NAMESPACES ===============================================================

namespace ACG {

//== IMPLEMENTATION ==========================================================

////////////////////////////////////////////////////////

void ZomeNodeData::setup( )
{
  std::cerr << __FILE__ << "::" << __FUNCTION__ << std::endl;
  std::cerr << " setting up ZomeNode meshes ... " << std::endl;
  setup_meshes();
  std::cerr << " setting up angles between directions ... " << std::endl;
  setup_angles();
  std::cerr << " setting up opposite directions map ... " << std::endl;
  setup_opposite_directions();
  //std::cerr << " setting up all planes ... " << std::endl;
  //setup_all_planes();
}

////////////////////////////////////////////////////////

void ZomeNodeData::setup_meshes( )
{
  // setup vertices of standard rhombicosidodecahedron
  std::vector< Vec3 > basisvertices;
  basisvertices.push_back( Vec3(1., 1., golden*golden*golden));
  basisvertices.push_back( Vec3(golden*golden, golden, 2.*golden));
  basisvertices.push_back( Vec3((2.+golden), 0., golden*golden));
  std::vector< Vec3 > rhombicosidodecahedron_vrts;
  rhombicosidodecahedron_vrts.reserve( 60);
  for( size_t i = 0; i < basisvertices.size(); ++i)
  {
    for( int p = 0; p < 3; ++p)
    {
      for( int s0 = 0; s0 < 2; ++s0)
      {
        for( int s1 = 0; s1 < 2; ++s1)
        {
          for( int s2 = 0; s2 < 2; ++s2)
          {
            double sign[] = { s0?1.:-1., s1?1.:-1., s2?1.:-1.};

            if( (basisvertices[i][(0+p)%3] == 0 && sign[(0+p)%3] == -1) || 
                (basisvertices[i][(1+p)%3] == 0 && sign[(1+p)%3] == -1) || 
                (basisvertices[i][(2+p)%3] == 0 && sign[(2+p)%3] == -1))
              continue;

            rhombicosidodecahedron_vrts.push_back( 
                Vec3( 
                  basisvertices[i][(0+p)%3]*sign[(0+p)%3],
                  basisvertices[i][(1+p)%3]*sign[(1+p)%3],
                  basisvertices[i][(2+p)%3]*sign[(2+p)%3]));
          }
        }
      }
    }
  }

  MeshT emptymesh;

  topological_mesh_ = emptymesh;
  visual_mesh_ = emptymesh;

  for( size_t i = 0; i < rhombicosidodecahedron_vrts.size(); ++i)
    topological_mesh_.add_vertex( rhombicosidodecahedron_vrts[i]);

  // setup faces
  {
    std::vector< VH > face;
    // triangle
    face.clear();
    face.push_back( VH(13));
    face.push_back( VH(9));
    face.push_back( VH(58));
    topological_mesh_.add_face(face);

    face.clear();
    face.push_back( VH(39));
    face.push_back( VH(31));
    face.push_back( VH(47));
    topological_mesh_.add_face(face);

    face.clear();
    face.push_back( VH(55));
    face.push_back( VH(3));
    face.push_back( VH(7));
    topological_mesh_.add_face(face);

    face.clear();
    face.push_back( VH(49));
    face.push_back( VH(22));
    face.push_back( VH(18));
    topological_mesh_.add_face(face);

    face.clear();
    face.push_back( VH(37));
    face.push_back( VH(46));
    face.push_back( VH(27));
    topological_mesh_.add_face(face);

    face.clear();
    face.push_back( VH(5));
    face.push_back( VH(1));
    face.push_back( VH(54));
    topological_mesh_.add_face(face);

    face.clear();
    face.push_back( VH(25));
    face.push_back( VH(42));
    face.push_back( VH(36));
    topological_mesh_.add_face(face);

    face.clear();
    face.push_back( VH(12));
    face.push_back( VH(56));
    face.push_back( VH(8));
    topological_mesh_.add_face(face);

    face.clear();
    face.push_back( VH(32));
    face.push_back( VH(40));
    face.push_back( VH(24));
    topological_mesh_.add_face(face);

    face.clear();
    face.push_back( VH(14));
    face.push_back( VH(10));
    face.push_back( VH(57));
    topological_mesh_.add_face(face);

    face.clear();
    face.push_back( VH(48));
    face.push_back( VH(16));
    face.push_back( VH(20));
    topological_mesh_.add_face(face);

    face.clear();
    face.push_back( VH(29));
    face.push_back( VH(38));
    face.push_back( VH(43));
    topological_mesh_.add_face(face);

    face.clear();
    face.push_back( VH(52));
    face.push_back( VH(0));
    face.push_back( VH(4));
    topological_mesh_.add_face(face);

    face.clear();
    face.push_back( VH(41));
    face.push_back( VH(34));
    face.push_back( VH(28));
    topological_mesh_.add_face(face);

    face.clear();
    face.push_back( VH(26));
    face.push_back( VH(44));
    face.push_back( VH(33));
    topological_mesh_.add_face(face);

    face.clear();
    face.push_back( VH(51));
    face.push_back( VH(19));
    face.push_back( VH(23));
    topological_mesh_.add_face(face);

    face.clear();
    face.push_back( VH(17));
    face.push_back( VH(50));
    face.push_back( VH(21));
    topological_mesh_.add_face(face);

    face.clear();
    face.push_back( VH(45));
    face.push_back( VH(30));
    face.push_back( VH(35));
    topological_mesh_.add_face(face);

    face.clear();
    face.push_back( VH(59));
    face.push_back( VH(11));
    face.push_back( VH(15));
    topological_mesh_.add_face(face);

    face.clear();
    face.push_back( VH(53));
    face.push_back( VH(6));
    face.push_back( VH(2));
    topological_mesh_.add_face(face);

    // quads
    face.clear();
    face.push_back( VH(39));
    face.push_back( VH(47));
    face.push_back( VH(59));
    face.push_back( VH(15));
    topological_mesh_.add_face(face);

    face.clear();
    face.push_back( VH(11));
    face.push_back( VH(9));
    face.push_back( VH(13));
    face.push_back( VH(15));
    topological_mesh_.add_face(face);

    face.clear();
    face.push_back( VH(6));
    face.push_back( VH(53));
    face.push_back( VH(35));
    face.push_back( VH(30));
    topological_mesh_.add_face(face);

    face.clear();
    face.push_back( VH(51));
    face.push_back( VH(23));
    face.push_back( VH(47));
    face.push_back( VH(31));
    topological_mesh_.add_face(face);

    face.clear();
    face.push_back( VH(50));
    face.push_back( VH(30));
    face.push_back( VH(45));
    face.push_back( VH(21));
    topological_mesh_.add_face(face);

    face.clear();
    face.push_back( VH(19));
    face.push_back( VH(17));
    face.push_back( VH(21));
    face.push_back( VH(23));
    topological_mesh_.add_face(face);

    face.clear();
    face.push_back( VH(17));
    face.push_back( VH(41));
    face.push_back( VH(28));
    face.push_back( VH(50));
    topological_mesh_.add_face(face);

    face.clear();
    face.push_back( VH(28));
    face.push_back( VH(34));
    face.push_back( VH(52));
    face.push_back( VH(4));
    topological_mesh_.add_face(face);

    face.clear();
    face.push_back( VH(29));
    face.push_back( VH(43));
    face.push_back( VH(19));
    face.push_back( VH(51));
    topological_mesh_.add_face(face);

    face.clear();
    face.push_back( VH(4));
    face.push_back( VH(0));
    face.push_back( VH(2));
    face.push_back( VH(6));
    topological_mesh_.add_face(face);

    face.clear();
    face.push_back( VH(2));
    face.push_back( VH(26));
    face.push_back( VH(33));
    face.push_back( VH(53));
    topological_mesh_.add_face(face);

    face.clear();
    face.push_back( VH(38));
    face.push_back( VH(14));
    face.push_back( VH(57));
    face.push_back( VH(43));
    topological_mesh_.add_face(face);

    face.clear();
    face.push_back( VH(52));
    face.push_back( VH(32));
    face.push_back( VH(24));
    face.push_back( VH(0));
    topological_mesh_.add_face(face);

    face.clear();
    face.push_back( VH(8));
    face.push_back( VH(56));
    face.push_back( VH(40));
    face.push_back( VH(32));
    topological_mesh_.add_face(face);

    face.clear();
    face.push_back( VH(36));
    face.push_back( VH(42));
    face.push_back( VH(56));
    face.push_back( VH(12));
    topological_mesh_.add_face(face);

    face.clear();
    face.push_back( VH(3));
    face.push_back( VH(1));
    face.push_back( VH(5));
    face.push_back( VH(7));
    topological_mesh_.add_face(face);

    face.clear();
    face.push_back( VH(1));
    face.push_back( VH(25));
    face.push_back( VH(36));
    face.push_back( VH(54));
    topological_mesh_.add_face(face);

    face.clear();
    face.push_back( VH(27));
    face.push_back( VH(3));
    face.push_back( VH(55));
    face.push_back( VH(37));
    topological_mesh_.add_face(face);

    face.clear();
    face.push_back( VH(18));
    face.push_back( VH(22));
    face.push_back( VH(20));
    face.push_back( VH(16));
    topological_mesh_.add_face(face);

    face.clear();
    face.push_back( VH(27));
    face.push_back( VH(46));
    face.push_back( VH(22));
    face.push_back( VH(49));
    topological_mesh_.add_face(face);

    face.clear();
    face.push_back( VH(25));
    face.push_back( VH(49));
    face.push_back( VH(18));
    face.push_back( VH(42));
    topological_mesh_.add_face(face);

    face.clear();
    face.push_back( VH(5));
    face.push_back( VH(54));
    face.push_back( VH(38));
    face.push_back( VH(29));
    topological_mesh_.add_face(face);

    face.clear();
    face.push_back( VH(14));
    face.push_back( VH(12));
    face.push_back( VH(8));
    face.push_back( VH(10));
    topological_mesh_.add_face(face);

    face.clear();
    face.push_back( VH(7));
    face.push_back( VH(31));
    face.push_back( VH(39));
    face.push_back( VH(55));
    topological_mesh_.add_face(face);

    face.clear();
    face.push_back( VH(46));
    face.push_back( VH(37));
    face.push_back( VH(13));
    face.push_back( VH(58));
    topological_mesh_.add_face(face);

    face.clear();
    face.push_back( VH(40));
    face.push_back( VH(16));
    face.push_back( VH(48));
    face.push_back( VH(24));
    topological_mesh_.add_face(face);

    face.clear();
    face.push_back( VH(57));
    face.push_back( VH(10));
    face.push_back( VH(34));
    face.push_back( VH(41));
    topological_mesh_.add_face(face);

    face.clear();
    face.push_back( VH(33));
    face.push_back( VH(44));
    face.push_back( VH(58));
    face.push_back( VH(9));
    topological_mesh_.add_face(face);

    face.clear();
    face.push_back( VH(45));
    face.push_back( VH(35));
    face.push_back( VH(11));
    face.push_back( VH(59));
    topological_mesh_.add_face(face);

    face.clear();
    face.push_back( VH(26));
    face.push_back( VH(48));
    face.push_back( VH(20));
    face.push_back( VH(44));
    topological_mesh_.add_face(face);



    // pentagons
    face.clear();
    face.push_back( VH(53));
    face.push_back( VH(33));
    face.push_back( VH(9));
    face.push_back( VH(11));
    face.push_back( VH(35));
    topological_mesh_.add_face(face);

    face.clear();
    face.push_back( VH(43));
    face.push_back( VH(57));
    face.push_back( VH(41));
    face.push_back( VH(17));
    face.push_back( VH(19));
    topological_mesh_.add_face(face);

    face.clear();
    face.push_back( VH(26));
    face.push_back( VH(2));
    face.push_back( VH(0));
    face.push_back( VH(24));
    face.push_back( VH(48));
    topological_mesh_.add_face(face);

    face.clear();
    face.push_back( VH(10));
    face.push_back( VH(8));
    face.push_back( VH(32));
    face.push_back( VH(52));
    face.push_back( VH(34));
    topological_mesh_.add_face(face);

    face.clear();
    face.push_back( VH(56));
    face.push_back( VH(42));
    face.push_back( VH(18));
    face.push_back( VH(16));
    face.push_back( VH(40));
    topological_mesh_.add_face(face);

    face.clear();
    face.push_back( VH(38));
    face.push_back( VH(54));
    face.push_back( VH(36));
    face.push_back( VH(12));
    face.push_back( VH(14));
    topological_mesh_.add_face(face);

    face.clear();
    face.push_back( VH(3));
    face.push_back( VH(27));
    face.push_back( VH(49));
    face.push_back( VH(25));
    face.push_back( VH(1));
    topological_mesh_.add_face(face);

    face.clear();
    face.push_back( VH(7));
    face.push_back( VH(5));
    face.push_back( VH(29));
    face.push_back( VH(51));
    face.push_back( VH(31));
    topological_mesh_.add_face(face);

    face.clear();
    face.push_back( VH(20));
    face.push_back( VH(22));
    face.push_back( VH(46));
    face.push_back( VH(58));
    face.push_back( VH(44));
    topological_mesh_.add_face(face);

    face.clear();
    face.push_back( VH(37));
    face.push_back( VH(55));
    face.push_back( VH(39));
    face.push_back( VH(15));
    face.push_back( VH(13));
    topological_mesh_.add_face(face);

    face.clear();
    face.push_back( VH(47));
    face.push_back( VH(23));
    face.push_back( VH(21));
    face.push_back( VH(45));
    face.push_back( VH(59));
    topological_mesh_.add_face(face);

    face.clear();
    face.push_back( VH(28));
    face.push_back( VH(4));
    face.push_back( VH(6));
    face.push_back( VH(30));
    face.push_back( VH(50));
    topological_mesh_.add_face(face);

  }
  topological_mesh_.request_face_normals();
  topological_mesh_.request_vertex_normals();
  topological_mesh_.update_normals();


  /// 3) modify to Zome -> make quads -> golden rectangles
  std::vector< Vec3 > vertex_update_vectors( topological_mesh_.n_vertices());

  // for each vertex find triangle then prev and next quad ... move vertices along common edge
  FH prevqfh(-1);
  FH nextqfh(-1);
  VH vh(-1);
  HEH heh(-1);
  for( VIter v_it = topological_mesh_.vertices_begin(); v_it != topological_mesh_.vertices_end(); ++v_it)
  {
    vh = *v_it;
    for( VOHIter voh_it( topological_mesh_.voh_iter( *v_it)); voh_it.is_valid(); ++voh_it)
    {
      FH fh( topological_mesh_.face_handle( *voh_it));
      if( topological_mesh_.valence( fh) == 3)
      {
        heh = *voh_it;
        prevqfh = topological_mesh_.face_handle( topological_mesh_.opposite_halfedge_handle( heh));
        nextqfh = topological_mesh_.face_handle( topological_mesh_.opposite_halfedge_handle( topological_mesh_.prev_halfedge_handle( heh)));
        break;
      }
    }
    vertex_update_vectors[v_it->idx()] = ( topological_mesh_.normal( prevqfh) % topological_mesh_.normal( nextqfh)).normalize();
  }

  // compute vertex shift to make quads -> golden rectangles
  Vec3 V = topological_mesh_.point( topological_mesh_.from_vertex_handle( heh)) - topological_mesh_.point( topological_mesh_.to_vertex_handle( heh));
  HEH nxtoppheh( topological_mesh_.next_halfedge_handle( topological_mesh_.opposite_halfedge_handle( heh)));
  Vec3 W = topological_mesh_.point( topological_mesh_.to_vertex_handle( nxtoppheh)) - topological_mesh_.point( topological_mesh_.from_vertex_handle( nxtoppheh));
  Scalar Vnorm( V.norm());
  V.normalize();
  Scalar Wnorm( W.norm());
  W.normalize();
  Scalar dotV( V|vertex_update_vectors[vh.idx()]);
  Scalar dotW( W|vertex_update_vectors[vh.idx()]);
  Scalar lambda( -(Vnorm - Wnorm * golden) / ( 2. * ( dotW * golden + dotV)));
  std::cerr  << "\t Vertices are shifted by lambda = " << lambda << " to obtain golden ratio quads..." << std::endl;

  // 4) update vertices
  for( VIter v_it = topological_mesh_.vertices_begin(); v_it != topological_mesh_.vertices_end(); ++v_it)
  {
    topological_mesh_.set_point( *v_it, topological_mesh_.point( *v_it) + lambda * vertex_update_vectors[v_it->idx()]);
  }

  // rescale to edge lengths 1 and golden
  for( VIter v_it = topological_mesh_.vertices_begin(); v_it != topological_mesh_.vertices_end(); ++v_it)
  {
    topological_mesh_.set_point( *v_it, topological_mesh_.point( *v_it)/golden);
  }


  /// 5) test properties
  // compute area
  Scalar area(0.);
  int ntri(0);
  int nquad(0);
  int npent(0);
  for( FIter f_it = topological_mesh_.faces_begin(); f_it != topological_mesh_.faces_end(); ++f_it)
  {
    Vec3 cog(0.,0.,0.);
    for( FHIter fh_it( topological_mesh_.fh_iter( *f_it)); fh_it.is_valid(); ++fh_it)
      cog += topological_mesh_.point( topological_mesh_.to_vertex_handle( *fh_it));
    cog /= Scalar( topological_mesh_.valence( *f_it));

    Scalar farea(0.);
    for( FHIter fh_it( topological_mesh_.fh_iter( *f_it)); fh_it.is_valid(); ++fh_it)
    {
      farea += ( ( topological_mesh_.point( topological_mesh_.from_vertex_handle( *fh_it)) - cog) % ( topological_mesh_.point( topological_mesh_.to_vertex_handle( *fh_it)) - cog)).norm()*0.5;
    }
    if( topological_mesh_.valence( *f_it) == 3)
    {
      //std::cerr << "triangle area " << farea << std::endl;
      ntri++;
    }
    else if( topological_mesh_.valence( *f_it) == 4)
    {
      //std::cerr << "quad area " << farea << std::endl;
      nquad++;
    }
    else if( topological_mesh_.valence( *f_it) == 5)
    {
      //std::cerr << "penta area " << farea << std::endl;
      npent++;
    }
    area += farea;
  }
  // wikipedia
  Scalar goalarea( 5.*sqrt(3./2.*(7.+3.*sqrt(5.))) + 3.*(5.+5.*sqrt(5.)+sqrt(2.*(5.+sqrt(5.)))+sqrt(5.+2.*sqrt(5.))));
  std::cerr << "\t ntri = " << ntri << " nquad = " << nquad << " npent = " << npent << std::endl;
  std::cerr << "\t rhombicosidodecahedron surface area is " << area << ", should be " << goalarea << std::endl;
  Scalar scalefactor( sqrt(goalarea / area ));
  std::cerr << "\t perform rescaling by factor " << scalefactor << std::endl;

  // rescale by scale factor also get diameter (distance between top and bottom points)
  Vec3 toppt(0.,0.,0.);
  Vec3 botpt(0.,0.,0.);
  for( VIter v_it = topological_mesh_.vertices_begin(); v_it != topological_mesh_.vertices_end(); ++v_it)
  {
    topological_mesh_.set_point( *v_it, topological_mesh_.point( *v_it)*scalefactor);
    if( topological_mesh_.point( *v_it)[2] > toppt[2])
      toppt = topological_mesh_.point( *v_it);
    if( topological_mesh_.point( *v_it)[2] < botpt[2])
      botpt = topological_mesh_.point( *v_it);
  }
  diameter_ = toppt[2] - botpt[2];

  // some offsets for the topological mesh
  Scalar surface_offset(1./6. * 1.);
  Scalar depth_offset(1.);

  // create axes
  edge_direction_.clear();
  edge_direction_.reserve( 62);
  edge_type_.clear();
  edge_type_.reserve( 62);
  edges_by_type_.clear();
  edges_by_type_.resize( 3);

  std::vector< int >& blue_edge_ids( edges_by_type_[BLUE]);
  std::vector< int >& yellow_edge_ids( edges_by_type_[YELLOW]);
  std::vector< int >& red_edge_ids( edges_by_type_[RED]);

  blue_edge_ids.clear();
  blue_edge_ids.reserve( 30);
  red_edge_ids.clear();
  red_edge_ids.reserve( 12);
  yellow_edge_ids.clear();
  yellow_edge_ids.reserve( 20);

  int cnttri(0);
  int cntquad(0);
  int cntpent(0);
  for( FIter f_it = topological_mesh_.faces_begin(); f_it != topological_mesh_.faces_end(); ++f_it)
  {
    Vec3* curaxis(NULL);
    if( topological_mesh_.valence( *f_it) == 3)
    {
      yellow_edge_ids.push_back( edge_direction_.size());
      edge_type_.push_back( YELLOW);
    }
    else if( topological_mesh_.valence( *f_it) == 4)
    {
      blue_edge_ids.push_back( edge_direction_.size());
      edge_type_.push_back( BLUE);
    }
    else if( topological_mesh_.valence( *f_it) == 5)
    {
      red_edge_ids.push_back( edge_direction_.size());
      edge_type_.push_back( RED);
    }

    // cog
    Vec3 cog(0., 0., 0.);
    for( FHIter fh_it( topological_mesh_.fh_iter( *f_it)); fh_it.is_valid(); ++fh_it)
      cog += topological_mesh_.point( topological_mesh_.to_vertex_handle( *fh_it));
    cog /= Scalar( topological_mesh_.valence( *f_it));

    cog.normalize();
    edge_direction_.push_back( cog);
  }

  /// create visual mesh
  visual_mesh_ = topological_mesh_;
  visual_mesh_.request_edge_status();
  visual_mesh_.request_face_status();
  visual_mesh_.request_vertex_status();
  visual_mesh_.request_vertex_normals();
  visual_mesh_.request_face_normals();
  visual_mesh_.update_normals();
  size_t nvold( topological_mesh_.n_vertices());
  //std::cerr << " nf " << visual_mesh_.n_faces() << " ne " << visual_mesh_.n_edges() << " nv " << visual_mesh_.n_vertices() << std::endl;

  // add new vertices, 1 per halfedge
  std::vector< VH > map_heh_to_first_new_vh( visual_mesh_.n_halfedges());
  for( HIter h_it = visual_mesh_.halfedges_begin(); h_it != visual_mesh_.halfedges_end(); ++h_it)
  {
    // get offset vector into face
    HEH heh( *h_it);
    HEH nxt( visual_mesh_.next_halfedge_handle( heh));
    Vec3 hehvec( visual_mesh_.point( visual_mesh_.from_vertex_handle( heh)) - visual_mesh_.point( visual_mesh_.to_vertex_handle( heh)));
    Vec3 nxtvec( visual_mesh_.point( visual_mesh_.to_vertex_handle( nxt)) - visual_mesh_.point( visual_mesh_.to_vertex_handle( heh)));
    Vec3 offvec( (hehvec + nxtvec).normalize());
    Vec3 corner( visual_mesh_.point( visual_mesh_.to_vertex_handle( heh)));

    map_heh_to_first_new_vh[h_it->idx()] = visual_mesh_.add_vertex( corner + offvec * surface_offset);
  }

  std::vector< VH > map_old_vh_to_new_vh( nvold);

  // add offset vertices below each original vertex
  // TODO FIXME Actually the offset must be orthogonal not to vertex but to face plane or else hole gets smaller...
  for( size_t v = 0; v < nvold; ++v)
  {
    VH vh(v);
    map_old_vh_to_new_vh[v] = visual_mesh_.add_vertex( visual_mesh_.point( vh) - depth_offset * visual_mesh_.normal( vh));
  }

  // delete old faces and build new ones
  size_t noldf( visual_mesh_.n_faces());

  for( size_t f = 0; f < noldf; ++f)
  {
    FH fh( f);
    std::vector< VH > oldvhs;
    std::vector< VH > newvhs;
    for( FHIter fh_it( visual_mesh_.fh_iter( fh)); fh_it.is_valid(); ++fh_it)
    {
      oldvhs.push_back( visual_mesh_.to_vertex_handle( *fh_it));
      newvhs.push_back( map_heh_to_first_new_vh[fh_it->idx()]);
    }

    visual_mesh_.delete_face( fh);

    // in face faces
    for( size_t i = 0; i < oldvhs.size(); ++i)
    {
      std::vector< VH > face;
      face.push_back( oldvhs[i]);
      face.push_back( oldvhs[(i+1)%oldvhs.size()]);
      face.push_back( newvhs[(i+1)%newvhs.size()]);
      face.push_back( newvhs[i]);
      visual_mesh_.add_face( face);
    }

    // add offset faces (into sphere)
    for( size_t i = 0; i < newvhs.size(); ++i)
    {
      std::vector< VH > face;
      face.push_back( newvhs[i]);
      face.push_back( newvhs[(i+1)%newvhs.size()]);
      face.push_back( map_old_vh_to_new_vh[oldvhs[(i+1)%oldvhs.size()].idx()]);
      face.push_back( map_old_vh_to_new_vh[oldvhs[i].idx()]);
      visual_mesh_.add_face( face);
    }
  }

  visual_mesh_.garbage_collection();
  visual_mesh_.update_normals();

  /// 6) compute radius of tri, quad and penta holes and compute upvectors
  std::cerr << " setting up up-vectors of holes ... " << std::endl;
  cog_of_hole_.clear();
  cog_of_hole_.resize( topological_mesh_.n_faces());
  upvector_of_hole_.clear();
  upvector_of_hole_.resize( topological_mesh_.n_faces());
  for( size_t i = 0; i < topological_mesh_.n_faces(); ++i)
  {
    Vec3 cog( 0., 0., 0.);
    FHIter fh_it( topological_mesh_.fh_iter( FH(i)));
    Vec3 pt1( topological_mesh_.point( topological_mesh_.to_vertex_handle( *fh_it)));
    // for (non-symmetric) quad faces, first corner must be same
    if( topological_mesh_.valence( FH(i)) == 4)
    {
      Vec3 tovec( topological_mesh_.point( topological_mesh_.to_vertex_handle( *fh_it)) - topological_mesh_.point( topological_mesh_.from_vertex_handle( *fh_it)));
      HEH heh( topological_mesh_.prev_halfedge_handle( *fh_it));
      Vec3 frvec( topological_mesh_.point( topological_mesh_.to_vertex_handle( heh)) - topological_mesh_.point( topological_mesh_.from_vertex_handle( heh)));
      if( tovec.norm() < frvec.norm())
        pt1 = topological_mesh_.point( topological_mesh_.to_vertex_handle( heh));
    }

    FVIter fv_it( topological_mesh_.fv_iter( FH(i)));
    for(; fv_it.is_valid(); ++fv_it)
      cog += topological_mesh_.point( *fv_it);
    cog /= Scalar( topological_mesh_.valence( FH(i)));

    cog_of_hole_[i] = cog;
    upvector_of_hole_[i] = pt1 - cog;
  }
}

////////////////////////////////////////////////////////

void ZomeNodeData::setup_angles( )
{
  for( size_t i = 0; i < edge_direction_.size(); ++i)
    for( size_t j = 0; j < edge_direction_.size(); ++j)
    {
      directions_angles_(i,j) = acos( std::min( 1.0, std::max( -1.0, edge_direction_[i] | edge_direction_[j])));
    }
}

////////////////////////////////////////////////////////

void ZomeNodeData::setup_opposite_directions( )
{
  edge_opp_id_.clear();
  edge_opp_id_.resize( 62);
  for( size_t i = 0; i < edge_direction_.size(); ++i)
    for( size_t j = 0; j < edge_direction_.size(); ++j)
    {
      if( fabs(directions_angles_(i,j) - M_PI) < 0.75*M_PI/180.)//tolerance_)
      {
        edge_opp_id_[i] = j;
        edge_opp_id_[j] = i;
      }
    }
}
  

  
////////////////////////////////////////////////////////

void ZomeNodeData::add_visual_mesh_to_mesh( MeshT& _mesh, const Vec3& _pos, Scalar _spherediam) const
{
  // visual mesh is defined around origin, add scaled version around position _pos
  size_t nverts( _mesh.n_vertices());
  size_t nfaces( _mesh.n_faces());
  Scalar scalefactor( _spherediam/diameter());

  for( size_t v = 0; v < visual_mesh_.n_vertices(); ++v)
    _mesh.add_vertex( _pos + visual_mesh_.point( VH(v))*scalefactor);
  for( size_t f = 0; f < visual_mesh_.n_faces(); ++f)
  {
    CFVIter fv_it( visual_mesh_.cfv_iter( FH(f)));
    std::vector< VH > face;
    for(; fv_it.is_valid(); ++fv_it)
      face.push_back( VH( fv_it->idx() + nverts));
    _mesh.set_color( _mesh.add_face( face), Color( 154./255., 154./255., 154./255., 1.));
  }
}

////////////////////////////////////////////////////////
//
//void ZomeNodeData::strut_transform_to_hole( int _h, Scalar _spherediam, ACG::GLMatrixT<Scalar>& _trans) const
//{
//  /* struts are defined with the COG of one side at the origin, and the first corner at unit distance along the x-axis */
//  // 0) scale x-y-plane uniformly with |upvector_of_hole_|
//  // 1) rotate z-axis to hole direction
//  // 2) rotate (rotated x-axis) to up-vector of hole
//  // 3) translate to cog of hole (scaled!)
//
//  _trans.identity();
//
//  Scalar scale( upvector_of_hole_[_h].norm() * _spherediam/diameter());
//  ACG::GLMatrixT<Scalar> scalemat;
//  scalemat.identity();
//  scalemat.scale( scale, scale, 1.);
//
//  Vec3 rotaxis( (Vec3(0.,0.,1.) % dir(_h)).normalize());
//  Scalar rotangle( 180./M_PI * acos( std::min( 1.0, std::max( -1.0, Vec3(0.,0.,1.) | dir(_h)))));
//  if( fabs(rotangle -180.) < 0.75)
//    rotaxis = Vec3(1.,0.,0.);
//
//  ACG::GLMatrixT<Scalar> rotzmat;
//  rotzmat.identity();
//  rotzmat.rotate( rotangle, rotaxis);
//
//  Vec3 rotxaxis( 1., 0., 0.);
//  rotxaxis = rotzmat.transform_vector( rotxaxis);
//
//  rotaxis = (rotxaxis % upvector_of_hole_[_h]).normalize();
//  rotangle = 180./M_PI * acos( std::min( 1., std::max( -1., (rotxaxis | upvector_of_hole_[_h])/upvector_of_hole_[_h].norm())));
//
//  ACG::GLMatrixT<Scalar> rotxmat;
//  rotxmat.identity();
//  rotxmat.rotate( rotangle, rotaxis);
////
//  Vec3 translation( cog_of_hole_[_h]*_spherediam/diameter() - Vec3(0.,0.,0.));
//  ACG::GLMatrixT<Scalar> transmat;
//  transmat.identity();
//  transmat.translate( translation[0], translation[1], translation[2]);
//
//  _trans = transmat * rotxmat * rotzmat * scalemat;
//}

////////////////////////////////////////////////////////

void ZomeNodeData::get_strut_scale_origin_zaxis_and_xaxis( Scalar _spherediam, int _h, Scalar& _balldim, Scalar& _scale, Vec3& _origin, Vec3& _zaxis, Vec3& _xaxis) const
{
  _scale = _spherediam / diameter() * upvector_of_hole_[_h].norm();

  _origin = cog_of_hole_[_h]*_spherediam/diameter();

  _balldim = _origin.norm();

  _zaxis = dir(_h);

  _xaxis = upvector_of_hole_[_h]/upvector_of_hole_[_h].norm();
}

////////////////////////////////////////////////////////

void ZomeNodeData::print_info() const
{
  std::cerr << " ----- ZomeNodeData info ----- " << std::endl;
  std::cerr << " - tolerance = " << tolerance() << std::endl;
  std::cerr << " - diameter  = " << diameter() << std::endl;
  std::cerr << " - direc. vec= " << directions_vec().size() << std::endl;
  std::cerr << " - dirs. 0..2= " << std::endl << dir(0) << std::endl << dir(1) << std::endl << dir(2) << std::endl;
  std::cerr << " - oppids    = " << std::endl;
  for( size_t i = 0; i < edge_opp_id_.size(); ++i)
    std::cerr <<  " --- i = " << i << " vs. " <<  edge_opp_id_[i] << std::endl;
  std::cerr << " - angles    = " << std::endl;
  std::cerr << directions_angles_ << std::endl;
}
  
  
//=============================================================================
} // namespace ACG
//=============================================================================
