//=============================================================================
//
//  CLASS ZomeNodeData
//
//=============================================================================


#ifndef ACG_ZOMENODEDATAT_HH
#define ACG_ZOMENODEDATAT_HH


//== INCLUDES =================================================================
#include "Types.hh"

#include "MemoryInclude.hh"


//== FORWARDDECLARATIONS ======================================================

//== NAMESPACES ===============================================================

namespace ACG {

//== CLASS DEFINITION =========================================================



	      
/** \class ZomeNodeData ZomeNodeDataT.hh <ACG/.../ZomeNodeDataT.hh>

    Brief Description.
  
    A more elaborate description follows.
*/



class ZomeNodeData
{
public:

  /// Constructor
  ZomeNodeData( Scalar _tolerance = 1e-3 ) : directions_angles_(62,62), tolerance_(_tolerance)
  {
    //std::cerr << "CONSTRUCTOR " << directions_angles_.rows() << " x " << directions_angles_.cols() << std::endl;


    setup();
  }
 
  /// Destructor
  ~ZomeNodeData() 
  {
  }

  /// get closed ball mesh
  const MeshT& topological_mesh() const { return topological_mesh_; }
        MeshT& topological_mesh()       { return topological_mesh_; }
  /// get Zome adapted mesh
  const MeshT& visual_mesh() const { return visual_mesh_; }
        MeshT& visual_mesh()       { return visual_mesh_; }
  /// get vector of all edge directions 0..61
  const std::vector< Vec3 > & directions_vec() const { return edge_direction_; }
        std::vector< Vec3 > & directions_vec()       { return edge_direction_; }
        
  /// edge direction i
  const Vec3& dir( int _i ) const { return edge_direction_[_i]; }
        Vec3& dir( int _i )       { return edge_direction_[_i]; }
  /// opposite edge id
  const int& oppid( int _i ) const { return edge_opp_id_[_i]; }
        int& oppid( int _i )       { return edge_opp_id_[_i]; }
  /// edge type RED = 0, BLUE = 1, YELLOW = 2
        EdgeType type( int _i ) const { return edge_type_[_i]; }
  /// angle between edges
  Scalar angle( int _i, int _j) const { return directions_angles_(_i, _j); }

  /// tolerance
  const Scalar& tolerance() const { return tolerance_; }
        Scalar& tolerance()       { return tolerance_; }
  /// ball height/diameter
  const Scalar& diameter() const { return diameter_; }
        //Scalar& diameter()       { return diameter_; }

  void add_visual_mesh_to_mesh( MeshT& _mesh, const Vec3& _pos, Scalar _spherediam) const;


  // get transformation: rotation and translation to move sturt (from origin) correctly 
  // to its hole
  //void strut_transform_to_hole( int _h, Scalar _spherediam, ACG::GLMatrixT<Scalar>& _trans) const;

  void get_strut_scale_origin_zaxis_and_xaxis( Scalar _spherediam, int _h, Scalar& _balldim, Scalar& _scale, Vec3& _origin, Vec3& _zaxis, Vec3& _xaxis) const;

  void print_info() const;
private:

  /// setup members
  void setup();

  // setup meshes and edge directions and types
  void setup_meshes();

  // setup angles between directions
  void setup_angles();

  // setup mapping for dirid -> oppdirid
  void setup_opposite_directions();

  // ball representing meshes
  MeshT topological_mesh_;
  MeshT visual_mesh_;

  Scalar diameter_;
  
  // for modelling struts, get correct radius of tri, pent, and quad holes
  //// DONE, contained in (un-normalized) upvectors
  //Scalar tri_radius_;
  //Scalar quad_radius_;
  //Scalar penta_radius_;


  /// Vectors containing 3d directions of edges, the type of edge and a map to its opposite
  std::vector< Vec3 > edge_direction_;
  std::vector< std::vector< int > > edges_by_type_;
  std::vector< EdgeType > edge_type_;
  std::vector< int > edge_opp_id_;
  std::vector< Vec3 > upvector_of_hole_; //for rotating and visualizing struts
  std::vector< Vec3 > cog_of_hole_;

  /// Angles between vectors
  MatrixXd directions_angles_;

  Scalar tolerance_;

  //! planes and plane maps
//  std::vector< ZomePlane > planes_;
//  std::vector< int > orthogonal_plane_to_holeid_; // must not exist (-1);
//  std::vector< std::vector< int > > holeid_to_planeid_;
//  std::vector< std::vector< int > > planeid_to_holeid_;


};


//=============================================================================
} // namespace ACG
//=============================================================================
//=============================================================================
#endif // ACG_ZOMENODEDATAT_HH defined
//=============================================================================

