//=============================================================================
//
//  CLASS ZomeStrut
//
//=============================================================================


#ifndef ACG_ZOMESTRUTT_HH
#define ACG_ZOMESTRUTT_HH


//== INCLUDES =================================================================
#include "Types.hh"

#include "ZomeStrutData.hh"

#include "MemoryInclude.hh"

//== FORWARDDECLARATIONS ======================================================

//== NAMESPACES ===============================================================

namespace ACG {

//== CLASS DEFINITION =========================================================



	      
/** \class ZomeStrut ZomeStrutT.hh <ACG/.../ZomeStrutT.hh>

    Brief Description.
  
    A more elaborate description follows.
*/



class ZomeStrut
{
public:

  /// Constructor
  ZomeStrut( const ZomeStrutData* _strutdata = NULL) : strutdata_(_strutdata),  active_(false), lenid_(0)
  {
    nodeid_[0] = -1;
    nodeid_[1] = -1;
    holeid_[0] = -1;
    holeid_[1] = -1;
    polyid_[0] = -1;
    polyid_[1] = -1;
  }
  ZomeStrut( const ZomeStrutData* _strutdata, int _nodeid0, int _nodeid1, int _lenid) : strutdata_(_strutdata), active_(false), lenid_(_lenid)
  {
    nodeid_[0] = _nodeid0;
    nodeid_[1] = _nodeid1;
    holeid_[0] = -1;
    holeid_[1] = -1;
    polyid_[0] = -1;
    polyid_[1] = -1;
  }
  ZomeStrut( const ZomeStrutData* _strutdata, int _nodeid0, int _nodeid1, int _holeid0, int _holeid1, int _lenid) : strutdata_(_strutdata), active_(false), lenid_(_lenid)
  {
    nodeid_[0] = _nodeid0;
    nodeid_[1] = _nodeid1;
    holeid_[0] = _holeid0;
    holeid_[1] = _holeid1;
    polyid_[0] = -1;
    polyid_[1] = -1;
  }

  ZomeStrut( const ZomeStrut& _rhs) : strutdata_(_rhs.strutdata_), lenid_(_rhs.lenid_)
  {
    active_ = _rhs.active_;
    nodeid_[0] = _rhs.nodeid_[0];
    nodeid_[1] = _rhs.nodeid_[1];
    holeid_[0] = _rhs.holeid_[0];
    holeid_[1] = _rhs.holeid_[1];
    polyid_[0] = -1;
    polyid_[1] = -1;
  }
 
  /// Destructor
  ~ZomeStrut() 
  {
  }

  /// edge type of edge RED, BLUE, YELLOW
  const EdgeType& type() const { return strutdata_->type(); } 
        //EdgeType& type()       { return strutdata_.type(); } 
  /// length of edge according to global scale in strutdata_ 
  const Scalar& len( ) const { return strutdata_->len( lenid_); }
        //Scalar& len( )       { return strutdata_->len( lenid_); }
  /// lengthid of edge 0..2 -> if lenid_ = 1 and type = BLUE -> B2 edge
  const int& lenid( ) const { return lenid_; }
        int& lenid( )       { return lenid_; }
  /// active flag
  const bool& active( ) const { return active_; }
        bool& active( )       { return active_; }

  /// to/fromnode id
  const int& tonodeid( ) const { return nodeid_[1]; }
        int& tonodeid( )       { return nodeid_[1]; }
  const int& frnodeid( ) const { return nodeid_[0]; }
        int& frnodeid( )       { return nodeid_[0]; }
  /// to/from hole id
  const int& toholeid( ) const { return holeid_[1]; }
        int& toholeid( )       { return holeid_[1]; }
  const int& frholeid( ) const { return holeid_[0]; }
        int& frholeid( )       { return holeid_[0]; }

  /// neighboring polygons
  const int& polyone( ) const { return polyid_[0]; }
        int& polyone( )       { return polyid_[0]; }
  const int& polytwo( ) const { return polyid_[1]; }
        int& polytwo( )       { return polyid_[1]; }

  void set_strut_data( const ZomeStrutData* _data) { strutdata_ = _data; }

  ZomeStrut opposite_strut( ) const { 
    ZomeStrut retstrut( strutdata_, nodeid_[1], nodeid_[0], lenid_);
    retstrut.active_ = active_;
    retstrut.holeid_[0] = holeid_[1];
    retstrut.holeid_[1] = holeid_[0];
    retstrut.polyid_[0] = polyid_[1];
    retstrut.polyid_[1] = polyid_[0];
    return retstrut;
  }

  /// ZomeStrutData of this node type
  const ZomeStrutData& strutdata( ) const { return *strutdata_; }
  void set_strutdata_pointer( const ZomeStrutData* _pt) { strutdata_ = _pt; }

  void test();

  void print_info() const;
private:
  
  const ZomeStrutData* strutdata_;

  int nodeid_[2];
  int holeid_[2];
  int polyid_[2];
  bool active_;
  int lenid_;

};


//=============================================================================
} // namespace ACG
//=============================================================================
//=============================================================================
#endif // ACG_ZOMESTRUTT_HH defined
//=============================================================================

