//=============================================================================
//
//  CLASS ZomeStrutData - IMPLEMENTATION
//
//=============================================================================

#define ACG_ZOMESTRUTDATAT_C

//== INCLUDES =================================================================

#include "ZomeStrutData.hh"

//== NAMESPACES ===============================================================

namespace ACG {

//== IMPLEMENTATION ==========================================================

////////////////////////////////////////////////////////

void ZomeStrutData::setup( )
{
  if( isblue() )
    len(0) = bluebasescale_;
  else if( isred() )
    len(0) = sqrt( 2. + golden) * 0.5 * bluebasescale_;
  else if( isyellow() )
    len(0) = sqrt( 3.) * 0.5 * bluebasescale_;

    len(1) = len(0) * golden;
    len(2) = len(1) * golden;
}

////////////////////////////////////////////////////////


void ZomeStrutData::rescale( Scalar _newbluebasescale) 
{
  for( int i = 0; i < 3; ++i)
    len(i) *= _newbluebasescale/bluebasescale_;
  bluebasescale_ = _newbluebasescale;
}


////////////////////////////////////////////////////////
//
//void ZomeStrutData::setup_strut_geometry( )
//{
//  /* setup struts with profiles on x,y unit circle */
//  // total length of struts covered by balls (2*) measured on b(0)
//  Scalar totleninsideballs = bluebasescale_ * 1.8/7.5;
//  if( isblue())
//  {
//    std::vector< Vec3 > oripoints(4);
//    Scalar anglebegin( atan(golden));
//    Scalar anglenext ( M_PI - anglebegin);
//    Scalar gapangle( M_PI - 2.*anglebegin);
//    oripoints[0] = Vec3( cos( 0. ), sin( 0. ), 0.);
//    oripoints[1] = Vec3( cos( gapangle ), sin( gapangle ), 0.);
//    oripoints[2] = Vec3( cos( M_PI ), sin( M_PI ), 0.);
//    oripoints[3] = Vec3( cos( M_PI + gapangle ), sin( M_PI + gapangle ), 0.);
//
//    for( int l = 0; l < 3; ++l)
//    {
//      Scalar piecelen( len(l) - totleninsideballs);
//      Scalar zoffset(0.);
//      for( int i = 0; i < 4; ++i)
//        strut_mesh_[l].add_vertex( oripoints[i] + Vec3( 0., 0., zoffset));
//      zoffset += piecelen;
//      for( int i = 0; i < 4; ++i)
//        strut_mesh_[l].add_vertex( oripoints[i] + Vec3( 0., 0., zoffset));
//    }
//
//    for( int l = 0; l < 3; ++l)
//    {
//      for( int f = 0; f < 4; ++f)
//      {
//        std::vector< VH > face;
//        face.push_back( VH(f)   );
//        face.push_back( VH(f+4) );
//        face.push_back( VH(4+(f+1)%4) );
//        face.push_back( VH((f+1)%4) );
//        strut_mesh_[l].add_face(face);
//      }
//    }
//  }
//  else if( isyellow())
//  {
//    std::vector< Vec3 > oripoints(3);
//    std::vector< Vec3 > rotpoints(3);
//    Scalar anglebegin( 0.);
//    Scalar angleshift( 120.);
//    for( int i = 0; i < 3; ++i)
//    {
//      Scalar currangle( M_PI/180.*(anglebegin + angleshift * Scalar(i)));
//      oripoints[i] = ( Vec3( cos( currangle), sin(currangle), 0.));
//      rotpoints[i] = ( Vec3( cos( currangle + 0.5*angleshift), sin(currangle + 0.5*angleshift), 0.));
//    }
//
//    // metric length of mid piece
//    Scalar midpiecelen( 1.9/4.7 * (len(0) - totleninsideballs));
//    for( int l = 0; l < 3; ++l)
//    {
//      Scalar piece1and2len( (len(l) - totleninsideballs - midpiecelen)*0.5);
//      Scalar zoffset(0.);
//      for( int i = 0; i < 3; ++i)
//        strut_mesh_[l].add_vertex( oripoints[i] + Vec3( 0., 0., zoffset));
//      zoffset += piece1and2len;
//      for( int i = 0; i < 3; ++i)
//        strut_mesh_[l].add_vertex( oripoints[i] + Vec3( 0., 0., zoffset));
//      zoffset += midpiecelen;
//      for( int i = 0; i < 3; ++i)
//        strut_mesh_[l].add_vertex( rotpoints[i] + Vec3( 0., 0., zoffset));
//      zoffset += piece1and2len;
//      for( int i = 0; i < 3; ++i)
//        strut_mesh_[l].add_vertex( rotpoints[i] + Vec3( 0., 0., zoffset));
//    }
//
//    for( int l = 0; l < 3; ++l)
//    {
//      for( int f = 0; f < 3; ++f)
//      {
//        std::vector< VH > face;
//        face.push_back( VH(0+f)   );
//        face.push_back( VH(3+f) );
//        face.push_back( VH(6+f) );
//        face.push_back( VH(3+(f+1)%3) );
//        face.push_back( VH(0+(f+1)%3) );
//        strut_mesh_[l].add_face(face);
//        face.clear();
//        face.push_back( VH(f+6) );
//        face.push_back( VH(f+9) );
//        face.push_back( VH(9+(f+1)%3) );
//        face.push_back( VH(6+(f+1)%3) );
//        face.push_back( VH(3+(f+1)%3) );
//        strut_mesh_[l].add_face(face);
//      }
//    }
//  }
//  else if( isred())
//  {
//    std::vector< Vec3 > oripoints(5);
//    std::vector< Vec3 > rotpoints(5);
//    Scalar anglebegin( 0.);
//    Scalar angleshift( 72.);
//    for( int i = 0; i < 5; ++i)
//    {
//      Scalar currangle( M_PI/180.*(anglebegin + angleshift * Scalar(i)));
//      oripoints[i] = ( Vec3( cos( currangle), sin(currangle), 0.));
//      rotpoints[i] = ( Vec3( cos( currangle + 0.5*angleshift), sin(currangle + 0.5*angleshift), 0.));
//    }
//
//    // metric length of mid piece
//    Scalar midpiecelen( 1.5/5.3 * (len(0) - totleninsideballs));
//    for( int l = 0; l < 3; ++l)
//    {
//      Scalar piece1and2len( (len(l) - totleninsideballs - midpiecelen)*0.5);
//      Scalar zoffset(0.);
//      for( int i = 0; i < 5; ++i)
//        strut_mesh_[l].add_vertex( oripoints[i] + Vec3( 0., 0., zoffset));
//      zoffset += piece1and2len;
//      for( int i = 0; i < 5; ++i)
//        strut_mesh_[l].add_vertex( oripoints[i] + Vec3( 0., 0., zoffset));
//      zoffset += midpiecelen;
//      for( int i = 0; i < 5; ++i)
//        strut_mesh_[l].add_vertex( rotpoints[i] + Vec3( 0., 0., zoffset));
//      zoffset += piece1and2len;
//      for( int i = 0; i < 5; ++i)
//        strut_mesh_[l].add_vertex( rotpoints[i] + Vec3( 0., 0., zoffset));
//    }
//
//    for( int l = 0; l < 3; ++l)
//    {
//      for( int f = 0; f < 5; ++f)
//      {
//        std::vector< VH > face;
//        face.push_back( VH(f)   );
//        face.push_back( VH(f+5) );
//        face.push_back( VH(f+10) );
//        face.push_back( VH(5+(f+1)%5) );
//        face.push_back( VH((f+1)%5) );
//        strut_mesh_[l].add_face(face);
//        face.clear();
//        face.push_back( VH(f+10) );
//        face.push_back( VH(f+15) );
//        face.push_back( VH(15+(f+1)%5) );
//        face.push_back( VH(10+(f+1)%5) );
//        face.push_back( VH(5+(f+1)%5) );
//        strut_mesh_[l].add_face(face);
//      }
//    }
//  }
//  else
//    std::cerr << __FUNCTION__ << " INVALID strut color !" << std::endl;
//}

////////////////////////////////////////////////////////

void ZomeStrutData::get_strut_geometry( int _l, Scalar _balldim, Scalar _scale, const Vec3& _origin, const Vec3& _zaxis, const Vec3& _xaxis, MeshT& _mesh) const
{
  // local coordinates
  const Vec3& xaxis( _xaxis);
  const Vec3& zaxis( _zaxis);
  const Vec3  yaxis( (zaxis % xaxis).normalize());
  const Vec3& origin( _origin);

  /* setup struts with profiles on x,y unit circle */
  // total length of struts covered by balls (2*) measured on b(0)
  //Scalar totleninsideballs = bluebasescale_ * 1.8/7.5;
  // need to know radius of ball in world coordinates
  Scalar totleninsideballs(_balldim*2.);
  
  size_t noldverts(_mesh.n_vertices());
  if( isblue())
  {
    std::vector< Vec3 > oripoints(4);
    Scalar anglebegin( atan(golden));
    Scalar anglenext ( M_PI - anglebegin);
    Scalar gapangle( M_PI - 2.*anglebegin);
    oripoints[0] = origin + _scale * cos( 0. ) * xaxis + _scale * sin( 0.) * yaxis;
    oripoints[1] = origin + _scale * cos( gapangle ) * xaxis + yaxis * _scale * sin( gapangle );
    oripoints[2] = origin + _scale * cos( M_PI ) * xaxis + _scale * sin( M_PI ) * yaxis;
    oripoints[3] = origin + _scale * cos( M_PI + gapangle ) * xaxis + _scale * sin( M_PI + gapangle ) * yaxis;

    Scalar piecelen( len(_l) - totleninsideballs);
    Scalar zoffset(0.);
    for( int i = 0; i < 4; ++i)
      _mesh.add_vertex( oripoints[i] + zaxis * zoffset);
    zoffset += piecelen;
    for( int i = 0; i < 4; ++i)
      _mesh.add_vertex( oripoints[i] + zaxis * zoffset);

    for( int f = 0; f < 4; ++f)
    {
      std::vector< VH > face;
      face.push_back( VH((f+1)%4+noldverts) );
      face.push_back( VH(4+(f+1)%4+noldverts) );
      face.push_back( VH(f+noldverts+4) );
      face.push_back( VH(f+noldverts)   );
      _mesh.add_face(face);
    }
  }
  else if( isyellow())
  {
    std::vector< Vec3 > oripoints(3);
    std::vector< Vec3 > rotpoints(3);
    Scalar anglebegin( 0.);
    Scalar angleshift( 120. * M_PI/180.);
    for( int i = 0; i < 3; ++i)
    {
      Scalar currangle( anglebegin + angleshift * Scalar(i));
      oripoints[i] = origin + _scale * cos( currangle) * xaxis + _scale * sin(currangle) * yaxis;
      rotpoints[i] = origin + _scale * cos( currangle + 0.5*angleshift) * xaxis + _scale * sin(currangle + 0.5*angleshift) * yaxis;
    }

    // metric length of mid piece
    Scalar midpiecelen( 1.9/4.7 * (len(0) - totleninsideballs)*golden);
    Scalar piece1and2len( (len(_l) - totleninsideballs - midpiecelen)*0.5);
    Scalar zoffset(0.);
    for( int i = 0; i < 3; ++i)
      _mesh.add_vertex( oripoints[i] + zaxis * zoffset);
    zoffset += piece1and2len;
    for( int i = 0; i < 3; ++i)
      _mesh.add_vertex( oripoints[i] + zaxis * zoffset);
    zoffset += midpiecelen;
    for( int i = 0; i < 3; ++i)
      _mesh.add_vertex( rotpoints[i] + zaxis * zoffset);
    zoffset += piece1and2len;
    for( int i = 0; i < 3; ++i)
      _mesh.add_vertex( rotpoints[i] + zaxis * zoffset);

    for( int f = 0; f < 3; ++f)
    {
      std::vector< VH > face;

      face.push_back( VH(0+(f+1)%3+noldverts) );
      face.push_back( VH(3+(f+1)%3+noldverts) );
      face.push_back( VH(3+f+noldverts) );
      face.push_back( VH(0+f+noldverts)   );
      _mesh.add_face(face);
      face.clear();

      face.push_back( VH(3+(f+1)%3+noldverts) );
      face.push_back( VH(6+f+noldverts) );
      face.push_back( VH(3+f+noldverts) );
      _mesh.add_face(face);
      face.clear();

      face.push_back( VH(3+(f+1)%3+noldverts) );
      face.push_back( VH(6+(f+1)%3+noldverts) );
      face.push_back( VH(f+6+noldverts) );
      _mesh.add_face(face);

      face.clear();
      face.push_back( VH(6+(f+1)%3+noldverts) );
      face.push_back( VH(9+(f+1)%3+noldverts) );
      face.push_back( VH(f+9+noldverts) );
      face.push_back( VH(f+6+noldverts) );
      _mesh.add_face(face);
    }
  }
  else if( isred())
  {
    std::vector< Vec3 > oripoints(5);
    std::vector< Vec3 > rotpoints(5);
    Scalar anglebegin( 0.);
    Scalar angleshift( 72. * M_PI / 180.);
    for( int i = 0; i < 5; ++i)
    {
      Scalar currangle( anglebegin + angleshift * Scalar(i));
      oripoints[i] = origin + _scale * cos( currangle) * xaxis + _scale * sin(currangle) * yaxis;
      rotpoints[i] = origin + _scale * cos( currangle + 0.5*angleshift) * xaxis + _scale * sin(currangle + 0.5*angleshift) * yaxis;
    }

    // metric length of mid piece
    Scalar midpiecelen( 1.5/5.3 * (len(0) - totleninsideballs)*golden);
    Scalar piece1and2len( (len(_l) - totleninsideballs - midpiecelen)*0.5);
    Scalar zoffset(0.);
    for( int i = 0; i < 5; ++i)
      _mesh.add_vertex( oripoints[i] + zaxis * zoffset);
    zoffset += piece1and2len;
    for( int i = 0; i < 5; ++i)
      _mesh.add_vertex( oripoints[i] + zaxis * zoffset);
    zoffset += midpiecelen;
    for( int i = 0; i < 5; ++i)
      _mesh.add_vertex( rotpoints[i] + zaxis * zoffset);
    zoffset += piece1and2len;
    for( int i = 0; i < 5; ++i)
      _mesh.add_vertex( rotpoints[i] + zaxis * zoffset);

    for( int f = 0; f < 5; ++f)
    {
      std::vector< VH > face;
      face.push_back( VH((f+1)%5+noldverts) );
      face.push_back( VH(5+(f+1)%5+noldverts) );
      face.push_back( VH(f+5+noldverts) );
      face.push_back( VH(f+noldverts)   );
      _mesh.add_face(face);

      face.clear();
      face.push_back( VH(5+(f+1)%5+noldverts) );
      face.push_back( VH(f+10+noldverts) );
      face.push_back( VH(f+5+noldverts) );
      _mesh.add_face(face);

      face.clear();
      face.push_back( VH(5+(f+1)%5+noldverts) );
      face.push_back( VH(10+(f+1)%5+noldverts) );
      face.push_back( VH(f+10+noldverts) );
      _mesh.add_face(face);

      face.clear();
      face.push_back( VH(10+(f+1)%5+noldverts) );
      face.push_back( VH(15+(f+1)%5+noldverts) );
      face.push_back( VH(f+15+noldverts) );
      face.push_back( VH(f+10+noldverts) );
      _mesh.add_face(face);
    }
  }
  else
    std::cerr << __FUNCTION__ << " INVALID strut color !" << std::endl;
}

////////////////////////////////////////////////////////

//void ZomeStrutData::add_rotated_and_translated_strut_mesh( const ACG::GLMatrixT<Scalar>& _trans, int _l, MeshT& _mesh) const
//{
//  int len(_l);
//  size_t nv( strut_mesh_[len].n_vertices());
//  size_t nf( strut_mesh_[len].n_faces());
//
//  size_t meshnv( _mesh.n_vertices());
//  for( size_t i = 0; i < nv; ++i)
//  {
//    _mesh.add_vertex( _trans.transform_point(strut_mesh_[len].point( VH(i))));
//  }
//
//  for( size_t i = 0; i < nf; ++i)
//  {
//    std::vector< VH > face;
//    for( CFVIter fv_it( strut_mesh_[len].cfv_iter( FH(i))); fv_it; ++fv_it)
//      face.push_back( VH( meshnv + fv_it.handle().idx()));
//    _mesh.add_face( face);
//  }
//}
//  
  
////////////////////////////////////////////////////////

void ZomeStrutData::print_info( ) const
{
  std::cerr << " ----- ZomeStrutData info ----- " << std::endl;
  std::cerr << " - type       = " << type_ << std::endl;
  std::cerr << " - bluescale  = " << bluebasescale_ << std::endl;
  std::cerr << " - lenghts    = " << len_[0] << " " << len_[1] << " " << len_[2] << std::endl;
}

  
//=============================================================================
} // namespace ACG
//=============================================================================
