//=============================================================================
//
//  CLASS ZomeStrutData
//
//=============================================================================


#ifndef ACG_ZOMESTRUTDATAT_HH
#define ACG_ZOMESTRUTDATAT_HH


//== INCLUDES =================================================================
#include "Types.hh"

#include "MemoryInclude.hh"



//== FORWARDDECLARATIONS ======================================================

//== NAMESPACES ===============================================================

namespace ACG {

//== CLASS DEFINITION =========================================================



	      
/** \class ZomeStrutData ZomeStrutDataT.hh <ACG/.../ZomeStrutDataT.hh>

    Brief Description.
  
    A more elaborate description follows.
*/



class ZomeStrutData
{
public:

  /// Constructor
  ZomeStrutData( EdgeType _type = BLUE, Scalar _bluebasescale = 1.) : type_(_type), bluebasescale_(_bluebasescale)
  {
    setup();
  }
 
  /// Destructor
  ~ZomeStrutData() 
  {
  }

  ZomeStrutData& operator=( const ZomeStrutData& _rhs)
  {
    type_ = _rhs.type_;
    bluebasescale_ = _rhs.bluebasescale_;
    setup();
    return *this;
  }
  const Scalar& len( int _i) const { return len_[_i]; }
        Scalar& len( int _i)       { return len_[_i]; }

  const EdgeType& type( ) const { return type_; }

  bool isblue() const { return type_ == BLUE; }
  bool isred() const { return type_ == RED; }
  bool isyellow() const { return type_ == YELLOW; }
  
  void get_strut_geometry( int _l, Scalar _balldim, Scalar _scale, const Vec3& _origin, const Vec3& _zaxis, const Vec3& _xaxis, MeshT& _mesh) const;

  /// setup members
  void setup( );

  /// USE WITH CAUTION
  void rescale( Scalar _newbluebasescale);

  void print_info() const;
private:

  
  // edge type
  EdgeType type_;

  // default 1.0
  Scalar bluebasescale_;
  
  Scalar len_[3];

  // setup strut geometry (unit-circle radius, rescale when drawing)
  //void setup_strut_geometry();
  //MeshT strut_mesh_[3]; // one for each length

};


//=============================================================================
} // namespace ACG
//=============================================================================
//=============================================================================
#endif // ACG_ZOMESTRUTDATAT_HH defined
//=============================================================================

