--------------------------------------------------------------------------------
-- Copyright (c) 2011, Computer Graphics Group RWTH Aachen University         --
-- All rights reserved.                                                       --
--------------------------------------------------------------------------------

dofile("LuaScripts/Track.lua")

Chunk = {}
Chunk.__index = Chunk

function Chunk:new(tracks,connectors)
  local self = {}
  setmetatable(self,Chunk)
  self.tracks = tracks
  self.connectors = connectors
  return self
end

function Chunk:addSubchunk(chunk)
  local track = self.tracks
  local cons = self.connectors
  local trackCount = table.getn(self.tracks)
  if (trackCount > 0) then
    table.insert(cons,Connector:new(self.tracks[trackCount],chunk.tracks[1],0,0))
  end
    for _,t in pairs(chunk.tracks) do
      table.insert(track,t)
    end
    for _,c in pairs(chunk.connectors) do
      table.insert(cons,c)
    end
    return Chunk:new(track,cons)
end

function Chunk.__concat(c1,c2)
  return c1:addSubchunk(c2)
end

function Chunk:generate(cchunk,floats,lt)
  for i,t in pairs(self.tracks) do
    if (i == 1) then
      lastTrack = t:generateWithFloats(cchunk,floats)
      lt:setSuccessor(lastTrack,0,0)
    else
      lastTrack = t:generate(cchunk)
    end
  end
  for _,c in pairs(self.connectors) do
    c:connect(currentChunk)
  end
  currentChunk:setLastTrack(lastTrack)
  for i,t in pairs(self.tracks) do
    entityGenerator(t.ctrack,t.laneCount)
  end
end
