--------------------------------------------------------------------------------
-- Copyright (c) 2011, Computer Graphics Group RWTH Aachen University         --
-- All rights reserved.                                                       --
--------------------------------------------------------------------------------

function partition(len,count,min)
  local rem = len - count*min
  local a = {}
  for i = 0,count-2 do
    local x = math.floor(math.random()*rem)
    a[i] = x+min
    rem  = rem-x
  end
  a[count-1] = rem+min
  for i = 0,100 do
    local r1 = math.floor(math.random()*count)
    local r2 = math.floor(math.random()*count)
    local z = a[r1]
    a[r1] = a[r2]
    a[r2] = z
  end
  return a
end

function divideChunk()
  local lens = partition(chunkLength,chunkParts,chunkLength/chunkParts-50)
  local res = {}
  local x = 0
  for i = 0,(chunkParts-1) do
    local y = math.random()*chunkLength/2 - chunkLength/4
    local z = math.random()*chunkLength/2 - chunkLength/4
    res[i] =  Vector:new(x+lens[i],y,z)
    x = x+lens[i]
  end
  return res
end

