--------------------------------------------------------------------------------
-- Copyright (c) 2011, Computer Graphics Group RWTH Aachen University         --
-- All rights reserved.                                                       --
--------------------------------------------------------------------------------
totalCount = {0, 0, 0, 0, 0, 0}

function colorPowerUp(toGenerate)
    local powerUps = {}
    colorCount = {toGenerate,toGenerate,toGenerate,toGenerate,toGenerate,toGenerate}
    laneColor = 0
    for i=1, laneNumber do
        powerUps[i] = {}
        laneColor = track:getColor(i-1) + 1 --consider that Lua counts from 1 while C++ counts from 0
        for j=1, toGenerate do
            powerUps[i][j] = chooseColor()
        end
    end
    return powerUps
end

function chooseColor()
    local length = table.getn(colorCount)
    local possibleColor = math.random(1,length)
    local counter = 0
    while(possibleColor == laneColor and laneNumber > 1) do
            possibleColor = math.random(1,length)
            if(counter > 0 and not(possibleColor == laneColor and laneNumber > 1)) then
                --print("In chunk "..currentChunk:getId()..", "..counter.." in ColorPowerUp.lua fails occured.")
            end
            counter = counter + 1
    end
    colorCount[possibleColor] = colorCount[possibleColor] - 1
    totalCount[possibleColor] = totalCount[possibleColor] + 1
    return possibleColor
end
