--------------------------------------------------------------------------------
-- Copyright (c) 2011, Computer Graphics Group RWTH Aachen University         --
-- All rights reserved.                                                       --
--------------------------------------------------------------------------------
dofile("LuaScripts/StandardBarrier.lua")
dofile("LuaScripts/ColorPowerUp.lua")
dofile("LuaScripts/SpecialPowerUps.lua")
dofile("LuaScripts/Asteroids.lua")

function entityGenerator()
    local type = track:getType()
    if(type == -1) then
        local exit = track:getPolylineResolution() -1
            for i=1, laneNumber do
                track:addEntity(5, i-1, 0, 17)
                track:addEntity(exit, i-1, 0, 18)
            end
        return
    end
    math.randomseed(seed)
    local samples = track:getPolylineResolution()
    local toGenerate = samples/space
    if(space<samples) then
        toGenerate = samples/space
    else
        toGenerate = samples/2
    end
    local powerUps = colorPowerUp(toGenerate)
    if(track:getLevel() > 0) then
        powerUps = barrier(toGenerate, powerUps)
        if(not(gamescom and track:getLevel() == 4)) then
            for i=1, specialPUs do
                powerUps = specialPowerUps(toGenerate, powerUps)
            end
        end
    end
    for i=1, laneNumber do
        for j=1, toGenerate do
            local random = math.random(1,0.9 * space)
            if(powerUps[i][j]==12 or powerUps[i][j]==15) then
                track:addEntity(j*space, i-1, 0, powerUps[i][j]) --no random displacement for speedUp and SpeedDown
            else
                track:addEntity(j*space + random, i-1, 0, powerUps[i][j])
            end
        end
    end
    --for i=1, laneNumber do
    --    track:addEntity(1, i-1, 0, 17)
    --end
    --racingLine(powerUps, space,  samples)
    local level = track:getLevel()
    if(level>0 and not(type == -1 or (level%8)==5)) then
        asteroids(toGenerate, space, samples)
    end
    --print("Rot: "..totalCount[1]..", Orange: "..totalCount[2]..", Gelb: "..totalCount[3]..", Grün: "..totalCount[4]..", Blau: "..totalCount[5]..", Violett: "..totalCount[6])
end

function racingLine(powerUps, space,  samples)
    local toGenerate = samples/space
    for i=1, laneNumber do
        for j=1, toGenerate do
            local line = 0
            if(j%2 == 1) then
                line = (i-1)/laneNumber * space
            else
                line = (laneNumber - i - 1)/laneNumber * 0.9 * space
            end
            track:addEntity(j*space + line, j/samples, i-1, 0, powerUps[i][j])
        end
    end
end
