--------------------------------------------------------------------------------
-- Copyright (c) 2011, Computer Graphics Group RWTH Aachen University         --
-- All rights reserved.                                                       --
--------------------------------------------------------------------------------

chunkLength = 1000
chunkParts = 5
maxParallelLanes = 6

function chunkBasedRnd(lb,ub)
  return (math.random()*(ub-lb)+lb)*chunkLength
end

--input: TrackInformation list, endtracks of the last subchunk
--output: endtracks of this subchunk
function createTracks(input,prevEnds)
  tracks = input[0]
  connectors = input[1]
  cTracks = {}
  endTracks = {}
  floats = SLB.FloatList()
  for _,t in pairs(tracks) do
    for _,v in pairs(t[0]) do floats:push(v) end
    track = currentChunk:createTrack(floats,t[1],laneColors)
    table.insert(cTracks,track)
  end
  for _,c in pairs(connectors) do
    if (c[0] < 0) then
      prevEnds[1-c[0]]:setSuccessor(cTracks[c[1]],c[2],c[3])
    else
      if (c[1] == "n") then
        table.insert(endTracks,cTracks[c[0]])
      else
        cTracks[c[0]]:setSuccessor(cTracks[c[1]],c[2],c[3])
      end
    end
  end
  return endTracks
end
