--------------------------------------------------------------------------------
-- Copyright (c) 2011, Computer Graphics Group RWTH Aachen University         --
-- All rights reserved.                                                       --
--------------------------------------------------------------------------------


function barrier(toGenerate, powerUps)
    if(laneNumber == 1) then
        return powerUps
    end
    local blocker = {}
    local blockerCount = 0
    local blockIndex = laneNumber-1--/2
    local type = track:getType()
    if(type==2) then
      blockIndex =  1 --helix should have less blocker
    end
    for i=1, toGenerate do
        if(gamescom and track:getLevel()>=4) then
            local lane = math.random(1, laneNumber)
            for j=1, laneNumber do
                if(not(j==lane)) then
                    powerUps[j][i] = 0
                end
            end
        else
            if((i-1)%(interspace+1) == 0) then --keep space between barrierlines
                for j=1, laneNumber do
                    if(math.random(0,1) == 1) then
                        blocker[j] = 1
                        blockerCount = blockerCount + 1
                    else
                        blocker[j] = 0
                    end
                end
                local counter = 0;
                while(blockerCount > blockIndex) do --avoid too much blocker
                    local index = math.random(1,laneNumber)
                    if(blocker[index] == 1) then
                        blocker[index] = 0
                        blockerCount = blockerCount - 1
                    end
                    if(counter > 0 and not(blockerCount > blockIndex)) then
                        --print("In chunk"..currentChunk:getId()..", "..counter.." were blocker deleted")
                    end
                    counter = counter + 1
                end
                for j=1, laneNumber do --insert blocker to PowerUplist
                    if(blocker[j] == 1) then
                        powerUps[j][i] = 0
                        blocker[j] = 0
                    end
                end
                blockerCount = 0
            end
        end
    end
    return powerUps
end
