--------------------------------------------------------------------------------
-- Copyright (c) 2011, Computer Graphics Group RWTH Aachen University         --
-- All rights reserved.                                                       --
--------------------------------------------------------------------------------

dofile("LuaScripts/Vector.lua")

NURBSPoint = {}
NURBSPoint.__index = NURBSPoint

Track = {}
Track.__index = Track

Connector = {}
Connector.__index = Connector

function NURBSPoint:new(pos,normal)
  local self = {}
  setmetatable(self,NURBSPoint)
  self.pos = pos
  self.normal = normal
  return self
end

function NURBSPoint:addToFloats(floats)
  floats:push(self.pos.x)
  floats:push(self.pos.y)
  floats:push(self.pos.z)
  floats:push(self.normal.x)
  floats:push(self.normal.y)
  floats:push(self.normal.z)
end

function NURBSPoint:add(p)
  return NURBSPoint:new(self.pos+p,self.normal)
end

function NURBSPoint.__add(p,v)
  return p:add(v)
end

function NURBSPoint:sub(p)
  return NURBSPoint:new(self.pos-p,self.normal)
end

function NURBSPoint.__sub(p,v)
  return p:sub(v)
end

function NURBSPoint:print()
  print((self.pos:string())..(self.normal:string()))
end

function Track:new(laneCount)
  local self = {}
  setmetatable(self,Track)
  self.nurbs = {}
  self.laneCount = laneCount
  self.ctrack = nil
  self.last = nil
  self.prelast = nil
  return self
end

function Track:addPoint(point)
  table.insert(self.nurbs,point)
  self.prelast = self.last
  self.last = point
  return self
end

function Track.__concat(t,p)
  return t:addPoint(p)
end

function Track:addToFloats(floats)
  for _,point in pairs(self.nurbs) do
    point:addToFloats(floats)
  end
end

function Track:length()
  local res = 0
  for i,_ in pairs(self.nurbs) do
    if (self.nurbs[i+1]) then
      local point = self.nurbs[i]
      local nextPoint = self.nurbs[i+1]
      res = res + (nextPoint.pos-point.pos):len()
    end
  end
  return res
end

function Track:clear()
  self.nurbs = {}
end

function Connector:new(track_a,track_b,a_left,b_left)
  local self = {}
  setmetatable(self,Connector)
  self.track_a = track_a
  self.track_b = track_b
  self.a_left = a_left
  self.b_left = b_left
  return self
end

function Connector:connect(chunk)
  local lc = math.min(self.track_a.laneCount,self.track_b.laneCount)
  local connector = Track:new(lc)
  local track_a_dir = (self.track_a.last.pos - self.track_a.prelast.pos)
  local track_b_dir = (self.track_b.nurbs[2].pos - self.track_b.nurbs[1].pos)
  local track_a_up = self.track_a.last.normal
  local track_b_up = self.track_b.nurbs[1].normal
  local track_a_right = track_a_up:cross(track_a_dir):normalize()
  local track_b_right = track_b_up:cross(track_b_dir):normalize()
  local track_a_offset = self.track_a.laneCount-self.a_left*2
  local track_b_offset = self.track_b.laneCount-self.b_left*2
  local dist = (self.track_b.nurbs[1].pos-self.track_a.last.pos):len()
  local a = self.track_a.last.pos
  local b = track_a_dir:normalize()
  local a_prime = self.track_b.nurbs[1].pos
  local b_prime = -track_b_dir:normalize()
  local a_hat = a-a_prime
  local b_hat = b-b_prime
  local as = a_hat:dot(a_hat)
  local bs = b_hat:dot(b_hat)-1
  local bas = a_hat:dot(b_hat)
  local lambda = -bas/bs + math.sqrt(((bas/bs)*(bas/bs))-(as/bs))
  local col  
  local connector = Track:new(lc)
  col = 1
  if (self.track_a.laneCount < self.track_b.laneCount) then
    connector = connector..(self.track_a.last)
    local point = NURBSPoint:new(self.track_a.last.pos+track_a_dir:normalize()*(dist/3),(self.track_a.last.normal*2-self.track_a.prelast.normal):normalize())
    connector = connector..point
    point = NURBSPoint:new(self.track_b.nurbs[1].pos-track_b_dir:normalize()*(dist/3)+track_b_right*(track_b_offset-track_a_offset),(self.track_b.nurbs[1].normal*2-self.track_b.nurbs[2].normal):normalize())
    connector = connector..point
    connector = connector..(self.track_b.nurbs[1]+track_b_right*(track_b_offset-track_a_offset))
    local ct = connector:generate(chunk)
    self.track_a.ctrack:setSuccessor(ct,0,0)
    ct:setSuccessor(self.track_b.ctrack,self.a_left,self.b_left)
    entityGenerator(ct,self.track_a.laneCount,dist/15)
  else
    connector = connector..(self.track_a.last+track_a_right*(track_a_offset-track_b_offset))
    local point = NURBSPoint:new(self.track_a.last.pos+track_a_dir:normalize()*(dist/3)+track_a_right*(track_a_offset-track_b_offset),(self.track_a.last.normal*2-self.track_a.prelast.normal):normalize())
    connector = connector..point
    point = NURBSPoint:new(self.track_b.nurbs[1].pos-track_b_dir:normalize()*(dist/3),(self.track_b.nurbs[1].normal*2-self.track_b.nurbs[2].normal):normalize())
    connector = connector..(self.track_b.nurbs[1]-track_b_dir)
    connector = connector..(self.track_b.nurbs[1])
    local ct = connector:generate(chunk)
    self.track_a.ctrack:setSuccessor(ct,self.a_left,self.b_left)
    ct:setSuccessor(self.track_b.ctrack,0,0)
    entityGenerator(ct,self.track_b.laneCount,dist/15)
  end
end

function Track:generate(chunk)
  return self:generateWithFloats(chunk,SLB.FloatList())
end

function Track:generateWithFloats(chunk,floats)
  self:addToFloats(floats)
  self.ctrack = chunk:createTrack(floats,self.laneCount,laneColors)
  return self.ctrack
end

