--------------------------------------------------------------------------------
-- Copyright (c) 2011, Computer Graphics Group RWTH Aachen University         --
-- All rights reserved.                                                       --
--------------------------------------------------------------------------------

Vector = {}
Vector.__index = Vector

function Vector:new(x,y,z)
  local self = {}
  setmetatable(self,Vector)
  self.x = x
  self.y = y
  self.z = z
  return self
end

function Vector:vec3ToLua(vec3)
  local self = {}
  setmetatable(self,Vector)
  self.x = vec3.x
  self.y = vec3.y
  self.z = vec3.z
  return self
end

function Vector:add(v)
  return Vector:new(self.x+v.x,self.y+v.y,self.z+v.z)
end

function Vector.__add(v1,v2)
  return v1:add(v2)
end

function Vector:sub(v)
  return Vector:new(self.x-v.x,self.y-v.y,self.z-v.z)
end

function Vector.__sub(v1,v2)
  return v1:sub(v2)
end

function Vector:unm()
  return Vector:new(-self.x,-self.y,-self.z)
end

function Vector.__unm(v)
  return v:unm()
end

function Vector:mul(a)
  return Vector:new(a*self.x,a*self.y,a*self.z)
end

function Vector.__mul(v,a)
  return v:mul(a)
end

function Vector:dot(v)
  return v.x*self.x+v.y*self.y+v.z*self.z
end

function Vector:len()
  return math.sqrt(self:dot(self))
end

function Vector:dist(v)
  return (self-v):len()
end

function Vector:cross(v)
  return Vector:new(self.y*v.z-self.z*v.y,self.z*v.x-self.x*v.z,self.x*v.y-self.y*v.x)
end

function Vector:normalize()
  return self*(1/self:len())
end

function Vector:string()
  return "("..tostring(self.x).." "..tostring(self.y).." "..tostring(self.z)..")"
end

function Vector:angle(a)
  return math.acos(self:dot(a) / (self:len() * a:len()))
end

function Vector:rotate(axis,angle)
  return self*math.cos(angle) + (axis:cross(self))*math.sin(angle) + axis*(axis:dot(self))*(1-math.cos(angle))
end
