////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2011, Computer Graphics Group RWTH Aachen University         //
// All rights reserved.                                                       //
////////////////////////////////////////////////////////////////////////////////

#version 150
uniform sampler2D uSamplerTexture;
uniform sampler2D uSamplerNormalTexture;
uniform mat4 uPreviousModelViewProjectionMatrix;
uniform mat4 uModelViewProjectionMatrix;
uniform mat4 uViewMatrix;

//uniforms for CoC computation
uniform float uAperture;
uniform float uFocalLength;
uniform float uFocus;
uniform vec2 uCameraRange;
uniform float uGlow=0.0f;
uniform vec4 uColor=vec4(1.0f);
//uniform to determine wether sign bit in alpha channel shall be used as masking flag
uniform float uMaskFlag;
uniform float uRuntime;
uniform float uEntityID;

uniform vec3 uLightColor;
uniform vec3 uLightDir;

uniform float uSpecular;

in vec3 vEyeNormal;
in vec3 vEyeTangent;
in vec3 vEyeBitangent;
in vec2 vTexCoord;
in vec2 vVelocity;
in vec4 eyePos;

out vec4 fFragDataEyeNormal;
out vec4 fFragDataColor;
out vec4 fFragDataVelocity;

vec3 directionalLight(
    vec3 diffuse,
    float glow,
    vec3 specColor,
    vec3 ambient,
    vec3 eyeLightDir,
    vec3 lightColor,
    vec3 eyeVPos,
    vec3 eyeNormal
    );

void main(void)
{
    // normalize tangents
    vec3 eyeNormal = normalize(vEyeNormal);
    vec3 eyeTangent = normalize(vEyeTangent);
    vec3 eyeBitangent = normalize(vEyeBitangent);

    mat3 normalTransform = mat3(eyeTangent, eyeBitangent, eyeNormal);  //from tangentspace to eyespace

    vec3 newEyeNormal = normalize(normalTransform * (texture(uSamplerNormalTexture, vTexCoord).rgb*2.0-1.0));

    vec3 eyeLightDirection = normalize((uViewMatrix * vec4(uLightDir, 0.0)).xyz);

    vec4 tex = texture(uSamplerTexture, vTexCoord);

    // compute basic color using external function (from Lighting.fsh)
    if ( length(tex.rgb - vec3(1,0,0)) < 0.3 ) {
        fFragDataColor.rgb = vec3(1,0,0) * 5 * (1 - pow(abs(sin(uRuntime * 8 + uEntityID)), 1));
    }
    else {
        fFragDataColor.rgb = tex.rgb;
    }

    fFragDataColor.a = tex.a;
    fFragDataEyeNormal.rgb = (newEyeNormal * 0.5 + 0.5);
    fFragDataEyeNormal.a   = 0.0;

    fFragDataVelocity.xy = vVelocity;
    fFragDataVelocity.z = 0.0f;

    if(uMaskFlag > 0.0)
    {
        fFragDataVelocity.a = 1.0;
    }
    else
    {
        fFragDataVelocity.a = -1.0;
    }
    float objectDistance = -uCameraRange.y * uCameraRange.x / (gl_FragCoord.z * (uCameraRange.y - uCameraRange.x) - uCameraRange.y);
    fFragDataVelocity.a *= abs(uAperture * (uFocalLength * (objectDistance - uFocus)) / (objectDistance * (uFocus - uFocalLength)));
}
