////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2011, Computer Graphics Group RWTH Aachen University         //
// All rights reserved.                                                       //
////////////////////////////////////////////////////////////////////////////////

#version 150
uniform sampler2D uSamplerTexture;
uniform vec4 uColor;

uniform vec3 uLightColor;
uniform vec3 uLightDir;

uniform mat4 uPreviousModelViewProjectionMatrix;
uniform mat4 uModelViewProjectionMatrix;
uniform mat4 uViewMatrix;

//uniforms for CoC computation
uniform float uAperture;
uniform float uFocalLength;
uniform float uFocus;
uniform vec2 uCameraRange;

uniform float uSpecular;

in vec2 vVelocity;
in vec4 eyePos;
in vec3 vEyeNormal;
in vec2 vTexCoord;

out vec4 fFragDataEyeNormal;
out vec4 fFragDataColor;
out vec4 fFragDataVelocity;

vec3 directionalLight(
    vec3 diffuse,
    float glow,
    vec3 specColor,
    vec3 ambient,
    vec3 eyeLightDir,
    vec3 lightColor,
    vec3 eyeVPos,
    vec3 eyeNormal
    );


void main(void)
{
    vec4 texColor = texture(uSamplerTexture, vTexCoord);

    vec3 eyeLightDirection = normalize((uViewMatrix * vec4(uLightDir, 0.0)).xyz);
    vec3 eyeNormal = normalize(vEyeNormal);

    vec3 light=directionalLight(        uColor.rgb * texColor.rgb,
                                        uColor.a,
                                        vec3(0.7),
                                        vec3(0.5),
                                        eyeLightDirection,
                                        vec3(1.0),
                                        eyePos.xyz,
                                        eyeNormal
                                        );

    fFragDataColor.rgb = light;

    fFragDataEyeNormal.rgb = (eyeNormal * 0.5 + 0.5);
    fFragDataEyeNormal.a = 1.0;
    
    fFragDataVelocity.xy = vVelocity;
    fFragDataVelocity.z = 0.0;

    //fFragDataVelocity.a = 1.0;
    float objectdistance = -uCameraRange.y * uCameraRange.x / (gl_FragCoord.z * (uCameraRange.y - uCameraRange.x) - uCameraRange.y);
    fFragDataVelocity.a = abs(uAperture * (uFocalLength * (objectdistance - uFocus)) / (objectdistance * (uFocus - uFocalLength)));
}
