////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2011, Computer Graphics Group RWTH Aachen University         //
// All rights reserved.                                                       //
////////////////////////////////////////////////////////////////////////////////

#version 150
in vec4 aPosition;
in vec3 aNormal;
in vec2 aTexCoord;

uniform mat4 uModelViewProjectionMatrix;
uniform mat4 uPreviousModelViewProjectionMatrix;
uniform mat3 uNormalMatrix;
uniform mat4 uModelViewMatrix;

out vec3 vEyeNormal;
out vec2 vTexCoord;
out vec4 eyePos;
out vec2 vVelocity;

void main()
{
    vec4 p = uModelViewProjectionMatrix * aPosition;
    gl_Position = p;
    eyePos = uModelViewMatrix*aPosition;

    vec4 prevP = uPreviousModelViewProjectionMatrix * aPosition;
    vVelocity = (p/p.w - prevP/prevP.w).xy;


    vEyeNormal = uNormalMatrix * aNormal;
    vTexCoord  = aTexCoord;
}
