////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2011, Computer Graphics Group RWTH Aachen University         //
// All rights reserved.                                                       //
////////////////////////////////////////////////////////////////////////////////

#version 150
in vec4 aPosition;
in vec3 aNormal;
in vec2 aTexCoord;

uniform mat4 uModelViewProjectionMatrix;
uniform mat4 uPreviousModelViewProjectionMatrix;
uniform mat3 uNormalMatrix;
uniform mat4 uModelViewMatrix;

uniform float uElapsedTime;


out vec3 vEyeNormal;
out vec2 vTexCoord;
out vec4 eyePos;
out vec2 vVelocity;
out vec3 vNewPos;

void main()
{
    vec3 pos = aPosition.xyz;
    vec3 normal = aNormal;

    vec2 poxz = pos.xz;
    float yrotangle = uElapsedTime * 1.952;
    pos.xz = vec2(
                cos( yrotangle ) * poxz.x - sin( yrotangle ) * poxz.y,
                sin( yrotangle ) * poxz.x + cos( yrotangle ) * poxz.y
                );

    float l = length(pos);
    pos = mix(pos, pos * 1 / l / l, sin( uElapsedTime * 5 ) * .5 + .5);
    pos *= 1 + sin( uElapsedTime * 12.2 + pos.y * 6.28 ) * .2;

    normal = mix(normal, normal * 1 / l / l, sin( uElapsedTime * 5 ) * .5 + .5);


    vNewPos = pos;

    vec4 p = uModelViewProjectionMatrix * vec4( pos, aPosition.w );
    gl_Position = p;
    eyePos = uModelViewMatrix*aPosition;

    vec4 prevP = uPreviousModelViewProjectionMatrix * aPosition;
    vVelocity = (p/p.w - prevP/prevP.w).xy;


    vEyeNormal = uNormalMatrix * normal;
    vTexCoord  = aTexCoord;
}
