////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2011, Computer Graphics Group RWTH Aachen University         //
// All rights reserved.                                                       //
////////////////////////////////////////////////////////////////////////////////

#version 150
uniform vec3 uFirstColor;
uniform vec3 uSecondColor;

uniform float uElapsedSeconds;
uniform float uWormhole;
uniform float uWormAngle;

uniform samplerCube uSamplerSky;
uniform sampler2D uSamplerClouds;

in vec2 vTexCoordScreen;
in vec3 vSkyDir;
in vec3 vVelocity;

out vec4 fFragDataBlack0;
out vec4 fFragDataBlack1;
out vec4 fFragDataGradient;
out vec4 fFragDataVelocity;

vec3 wormholeColorVanilla()
{
    vec2 horizon = vec2(0.5, 1-0.3001);
    vec2 dir = vTexCoordScreen - horizon;
    float dis = length(dir);
    float angle = -.5 * uElapsedSeconds + atan(dir.y, dir.x) / 3.14159265;
    //if ( dir.y == 0 )
    //    angle = 3.14159265;
    vec4 clouds = textureLod(uSamplerClouds,vec2(angle * .5 - uWormAngle / 6.28, pow(dis, 0.05) - uElapsedSeconds * .1), 0);

    clouds *= clouds;
    clouds = mix(clouds, clouds * clouds * clouds, .5);

    vec4 blendclouds = textureLod(uSamplerClouds,vec2(angle * .5 - uWormAngle / 6.28 + 3.14 / 2, pow(dis, 0.05) - uElapsedSeconds * .1), 0);

    float blend = clamp(uWormhole * 2 - 1 + blendclouds.r, 0, 1);

    vec3 wormhole = vec3(0);
    wormhole += clouds.r * vec3(0, 1, 1);
    wormhole += clouds.g * vec3(0, 1, 0);
    wormhole += clouds.b * vec3(0, 0, 1);

    return wormhole;
}

float e(vec3 c)
{
    float time = uElapsedSeconds;

    c=cos(vec3(cos(c.r+time/6.0)*c.r-cos(c.g*3.0+time/5.0)*c.g, cos(time/4.0)*c.b/3.0*c.r-cos(time/7.0)*c.g, c.r+c.g+c.b+time));
    return dot(c*c,vec3(1.0))-1.0;
}



vec3 wormholeColor()
{
    vec2 centerShift = vec2(0.0, -0.15);

    // p is position from -1 .. 1
    vec2 p = 2.0 * (vTexCoordScreen+centerShift) - 1.0;
    float distToCenter = sqrt( dot(p,p) );

    vec2 uv;
    uv.x = 0.1*uElapsedSeconds + 0.05/distToCenter;
    uv.y = atan(p.y,p.x) / 3.1415926;

    float rotSpeed = 0.1;
    vec2 uv1 = uv + vec2(0.25, rotSpeed*uElapsedSeconds);
    vec2 uv2 = uv - vec2(0.5,  rotSpeed*uElapsedSeconds);

    vec2 rot = vec2(0,0.1*uElapsedSeconds);

    vec3 clouds0 = textureLod(uSamplerClouds, uv  +1.0*rot,     0).rgb;
    vec3 clouds1 = textureLod(uSamplerClouds, uv1 +1.3*rot,     0).rgb;
    vec3 clouds2 = textureLod(uSamplerClouds, uv2 +1.4*rot, 0).rgb;

    vec3 clouds = clouds2*clouds1/clouds0;
    clouds.rg  *= cos(distToCenter);
    clouds.rgb *= sqrt(distToCenter);

    //return clouds;

    vec3 wormhole = vec3(0);
    float x = sin(uElapsedSeconds);
    x += 1.0;
    x *= 0.5;
    wormhole += clouds.r * vec3(1, 0, 0);
    wormhole += clouds.g * vec3(0, 0.5+x, 0);
    wormhole += clouds.b * vec3(0, x, 1);

    return wormhole;
}

vec4 wormholeColor2( in float blend, in vec4 sky )
{
    vec2 centerShift = vec2(0.0, -0.15);

    // p is position from -1 .. 1
    vec2 p = 2.0 * (vTexCoordScreen+centerShift) - 1.0;
    float distToCenter = sqrt( dot(p,p) );

    vec2 uv;
    uv.x = 0.1*uElapsedSeconds + 0.05/distToCenter;
    uv.y = atan(p.y,p.x) / 3.1415926;

    float rotSpeed = 0.1;
    vec2 uv1 = uv + vec2(0.25, rotSpeed*uElapsedSeconds);
    vec2 uv2 = uv - vec2(0.5,  rotSpeed*uElapsedSeconds);

    vec2 rot = vec2(0,0.1*uElapsedSeconds);

    vec3 clouds0 = textureLod(uSamplerClouds, uv  +1.0*rot,     0).rgb;
    vec3 clouds1 = textureLod(uSamplerClouds, uv1 +1.3*rot,     0).rgb;
    vec3 clouds2 = textureLod(uSamplerClouds, uv2 +1.4*rot, 0).rgb;

    vec3 clouds = clouds2*clouds1/clouds0;
    clouds.rg  *= cos(distToCenter);
    clouds.rgb *= sqrt(distToCenter);

    //return clouds;

    vec3 wormhole = vec3(0);
    float x = sin(uElapsedSeconds);
    x += 1.0;
    x *= 0.5;
    wormhole += clouds.r * vec3(1, 0, 0);
    wormhole += clouds.g * vec3(0, 0.5+x, 0);
    wormhole += clouds.b * vec3(0, x, 1);

    //wormhole = clamp( wormhole, vec3(0), vec3(1) );

    float blendMod = (1.0-blend)*2.0 -1.0;
    float whSkyMix = 1.0-clamp( distToCenter-blendMod, 0, 1 );

    wormhole = mix( wormhole, sky.rgb, whSkyMix );

    return vec4( wormhole, 1.0 );
}


void main (void)
{
    fFragDataVelocity = vec4(vVelocity,1.0);
    fFragDataBlack0   = vec4(0.0);
    fFragDataBlack1   = vec4(0.0);
    vec4 sky = texture(uSamplerSky, normalize(vSkyDir));

    // wormhole
    vec3 wormhole = wormholeColor();

    if (uWormhole < 0.0001) {
        fFragDataGradient = sky;
    } else {
        fFragDataGradient = wormholeColor2( uWormhole, sky );
    }

    //fFragDataGradient = mix(sky, vec4(wormhole, 1), blend);
    /*fFragDataGradient = mix(vec4(vec3(angle / 6.28),1), fFragDataGradient, 0.01);
    fFragDataGradient = mix(clouds, fFragDataGradient, 0.01);
    fFragDataGradient = mix(vec4(wormhole, 1), fFragDataGradient, 0.01);*/
    //if ( abs(dir.y - 0) < 0.0001 )
     //   fFragDataGradient = vec4(1,0,0,1);
    //fFragDataGradient = mix(vec4(angle / 6.28, 0, 0, 1), fFragDataGradient, 0.01);
}
