////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2011, Computer Graphics Group RWTH Aachen University         //
// All rights reserved.                                                       //
////////////////////////////////////////////////////////////////////////////////

#version 150

uniform mat4 uProjectionMatrixInverse;
uniform mat3 uInvNormalMat;
uniform mat3 uPreviousInvNormalMat;
uniform mat3 uNormalMat;


in vec4 aPosition;

out vec2 vTexCoordScreen;
out vec3 vSkyDir;
out vec3 vVelocity;

void main()
{
    gl_Position     = aPosition;
    vTexCoordScreen = aPosition.xy * 0.5 + 0.5;

    vec4 eyeSkyDir = uProjectionMatrixInverse  * vec4(aPosition.xy,-1.0, 1.0);
    vSkyDir = uInvNormalMat * eyeSkyDir.xyz;
    vVelocity = uNormalMat * (uPreviousInvNormalMat * vec3(aPosition.xy,-1.0)) - vec3(aPosition.xy,-1.0);
}
