////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2011, Computer Graphics Group RWTH Aachen University         //
// All rights reserved.                                                       //
////////////////////////////////////////////////////////////////////////////////

#version 150
uniform samplerCube uSamplerSky;

in vec2 vTexCoordScreen;
in vec3 vSkyDir;
in vec3 vVelocity;

out vec4 fFragDataBlack0;
out vec4 fFragDataBlack1;
out vec4 fFragDataGradient;
out vec4 fFragDataVelocity;

void main (void)
{
    fFragDataVelocity = vec4(vVelocity,1.0);
    fFragDataBlack0   = vec4(0.0);
    fFragDataBlack1   = vec4(0.0);
    vec4 sky = texture(uSamplerSky, normalize(vSkyDir));
    fFragDataGradient = sky;
}
