////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2011, Computer Graphics Group RWTH Aachen University         //
// All rights reserved.                                                       //
////////////////////////////////////////////////////////////////////////////////

#version 150
uniform vec4 uColor;

uniform mat4 uPreviousModelViewProjectionMatrix;
uniform mat4 uModelViewProjectionMatrix;
uniform mat4 uViewMatrix;

in vec2 vVelocity;
in vec4 eyePos;
in vec3 vEyeNormal;
in vec2 vTexCoord;

out vec4 fFragDataEyeNormal;
out vec4 fFragDataColor;
out vec4 fFragDataVelocity;

vec3 directionalLight(
    vec3 diffuse,
    float glow,
    vec3 specColor,
    vec3 ambient,
    vec3 eyeLightDir,
    vec3 lightColor,
    vec3 eyeVPos,
    vec3 eyeNormal
    );


void main(void)
{
    vec3 eyeNormal = normalize(vEyeNormal);

    vec3 light=directionalLight(        uColor.rgb, // diffuse color
                                        0.0,        // glow
                                        vec3(0.0),  // specular
                                        vec3(0.5),  // ambient
                                        vec3(0.0, 0.0, 1.0),
                                        vec3(1.0),  // lightColor
                                        eyePos.xyz,
                                        eyeNormal
                                        );

    fFragDataColor.rgb = light;

    fFragDataEyeNormal.rgb = (eyeNormal * 0.5 + 0.5);
    fFragDataEyeNormal.a = 0.0;
    
    fFragDataVelocity = vec4(0.0);
}
