////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2011, Computer Graphics Group RWTH Aachen University         //
// All rights reserved.                                                       //
////////////////////////////////////////////////////////////////////////////////

#version 150
uniform sampler2D uTexture;

uniform vec4 uColor;
uniform float uTextureEnabled; // <- I know its not good, defines would be better

in vec3 vPosition;
in vec2 vTexCoord;

out vec4 fFragDataColor;

void main(void)
{
    vec4 outColor = uColor;
    if(uTextureEnabled > 0.0)
    {
        outColor *= texture(uTexture, vTexCoord);
    }
    // This is a ugly hack and should be replaced by some lighting function
    //   or better: remove this shader and make it possible to load a custom fragment shader!!!
    outColor *= (1.0-abs(vPosition.z));

    fFragDataColor = outColor;
}

