////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2011, Computer Graphics Group RWTH Aachen University         //
// All rights reserved.                                                       //
////////////////////////////////////////////////////////////////////////////////

#version 150
in vec4 aPosition;
in vec4 aNormal;
in vec4 aTexCoord;

uniform mat4 uPatchX;
uniform mat4 uPatchY;
uniform mat4 uPatchZ;

uniform mat4 uViewProjection;
uniform mat4 uTransformation;

out vec3 vPosition;
out vec2 vTexCoord;

void main()
{
    vTexCoord = vec2(aTexCoord);

    float u = aPosition.x;
    float v = aPosition.y;
    vec4 U = vec4(u*u*u, u*u, u, 1.0);
    vec4 V = vec4(v*v*v, v*v, v, 1.0);
    vec4 dU = vec4(3.0*u*u, 2.0*u, 1.0, 0.0);
    vec4 dV = vec4(3.0*v*v, 2.0*v, 1.0, 0.0);

    vec3 pos;
    pos.x = dot(U, uPatchX*V);
    pos.y = dot(U, uPatchY*V);
    pos.z = dot(U, uPatchZ*V);

    vec3 diffU;
    diffU.x = dot(dU, uPatchX*V);
    diffU.y = dot(dU, uPatchY*V);
    diffU.z = dot(dU, uPatchZ*V);
    diffU = normalize(diffU);

    vec3 diffV;
    diffV.x = dot(U, uPatchX*dV);
    diffV.y = dot(U, uPatchY*dV);
    diffV.z = dot(U, uPatchZ*dV);
    diffV = normalize(diffV);

    vec3 norm = normalize(cross(diffU, diffV));

    vPosition = pos+norm*aPosition.z;

    gl_Position = uViewProjection*uTransformation*vec4(vPosition, 1.0);
}

