////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2011, Computer Graphics Group RWTH Aachen University         //
// All rights reserved.                                                       //
////////////////////////////////////////////////////////////////////////////////

#version 150
uniform sampler2D uTextureSampler;
uniform sampler2D uCharMapSampler;

uniform vec4 uColor;
uniform float uTextureEnabled; // <- I know its not good, defines would be better

in vec2 vTexCoord;
in vec2 vCharTexCoord;

out vec4 fFragDataColor;

void main(void)
{
    float charTex = texture(uCharMapSampler, vCharTexCoord).r;

    if(charTex <= 0.0) discard;

    vec4 outColor = uColor * charTex;
    if(uTextureEnabled > 0.0)
    {
        outColor *= texture(uTextureSampler, vTexCoord);
    }
    outColor[3]*charTex;

    fFragDataColor = outColor;//outColor;
}

