////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2011, Computer Graphics Group RWTH Aachen University         //
// All rights reserved.                                                       //
////////////////////////////////////////////////////////////////////////////////

#version 150
#extension GL_ARB_explicit_attrib_location : enable

layout(location = 0) in vec4 aPosition;

uniform mat4 uPatchX;
uniform mat4 uPatchY;
uniform mat4 uPatchZ;

uniform vec2 uCharOffset;
uniform vec2 uCharSize;

uniform mat4 uViewProjection;
uniform mat4 uTransformation;

out vec2 vTexCoord;
out vec2 vCharTexCoord;

void main()
{
    vTexCoord = aPosition.xy;
    vCharTexCoord = uCharOffset + uCharSize * aPosition.xy;

    float u = aPosition.x;
    float v = aPosition.y;
    vec4 U = vec4(u*u*u, u*u, u, 1.0);
    vec4 V = vec4(v*v*v, v*v, v, 1.0);
    vec4 dU = vec4(3.0*u*u, 2.0*u, 1.0, 0.0);
    vec4 dV = vec4(3.0*v*v, 2.0*v, 1.0, 0.0);

    vec3 pos;
    pos.x = dot(U, uPatchX*V);
    pos.y = dot(U, uPatchY*V);
    pos.z = dot(U, uPatchZ*V);
//uViewProjection*
    gl_Position = uViewProjection*uTransformation*vec4(pos, 1.0);//vec4(u-0.5, 0.5-v, 0.0, 1.0);//uViewProjection*uTransformation*vec4(pos, 1.0);
}

